/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.compat;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.color.GradientColor;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.capabilities.CapabilityList;
import twilightforest.entity.monster.Redcap;

public class AdventureTwilightCompat {
    protected static final RegistryObject<Item> ORE_MAGNET = RegistryObject.create((ResourceLocation)new ResourceLocation("twilightforest", "ore_magnet"), (ResourceKey)Registries.f_256913_, (String)"apotheosis");
    protected static final RegistryObject<EntityType<Redcap>> REDCAP = RegistryObject.create((ResourceLocation)new ResourceLocation("twilightforest", "redcap"), (ResourceKey)Registries.f_256939_, (String)"apotheosis");

    public static void register() {
        GemBonus.CODEC.register(Apotheosis.loc("twilight_ore_magnet"), OreMagnetBonus.CODEC);
        GemBonus.CODEC.register(Apotheosis.loc("twilight_treasure_goblin"), TreasureGoblinBonus.CODEC);
        GemBonus.CODEC.register(Apotheosis.loc("twilight_fortification"), FortificationBonus.CODEC);
        MinecraftForge.EVENT_BUS.addListener(AdventureTwilightCompat::doGoblins);
    }

    @SubscribeEvent
    public static void doGoblins(EntityJoinLevelEvent e) {
        Redcap r;
        Entity entity = e.getEntity();
        if (entity instanceof Redcap && (r = (Redcap)entity).getPersistentData().m_128441_("apoth.treasure_goblin")) {
            r.f_21346_.m_262460_((Predicate)Predicates.alwaysTrue());
            r.f_21345_.m_262460_((Predicate)Predicates.alwaysTrue());
            r.f_21345_.m_25352_(10, (Goal)new AvoidEntityGoal((PathfinderMob)r, Player.class, 6.0f, 1.0, 1.25));
        }
    }

    public static class OreMagnetBonus
    extends GemBonus {
        public static final Codec<OreMagnetBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(OreMagnetBonus.gemClass(), (App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, OreMagnetBonus::new));
        protected final Map<LootRarity, StepFunction> values;

        public OreMagnetBonus(GemClass gemClass, Map<LootRarity, StepFunction> values) {
            super(Apotheosis.loc("twilight_ore_magnet"), gemClass);
            this.values = values;
        }

        @Override
        public InteractionResult onItemUse(ItemStack gem, LootRarity rarity, UseOnContext ctx) {
            BlockState state = ctx.m_43725_().m_8055_(ctx.m_8083_());
            if (state.m_60795_()) {
                return null;
            }
            Level level = ctx.m_43725_();
            Player player = ctx.m_43723_();
            player.m_6672_(ctx.m_43724_());
            ((Item)ORE_MAGNET.get()).m_5551_(gem, level, (LivingEntity)player, 0);
            player.m_5810_();
            int cost = this.values.get(rarity).getInt(0.0f);
            ctx.m_43722_().m_41622_(cost, (LivingEntity)player, user -> user.m_21190_(ctx.m_43724_()));
            return super.onItemUse(gem, rarity, ctx);
        }

        public Codec<? extends GemBonus> getCodec() {
            return CODEC;
        }

        @Override
        public GemBonus validate() {
            Preconditions.checkArgument((!this.values.isEmpty() ? 1 : 0) != 0, (Object)"No values provided!");
            return this;
        }

        @Override
        public boolean supports(LootRarity rarity) {
            return this.values.containsKey(rarity);
        }

        @Override
        public int getNumberOfUUIDs() {
            return 0;
        }

        @Override
        public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
            return Component.m_237110_((String)("bonus." + String.valueOf(this.getId()) + ".desc"), (Object[])new Object[]{this.values.get(rarity).getInt(0.0f)}).m_130940_(ChatFormatting.YELLOW);
        }
    }

    public static class TreasureGoblinBonus
    extends GemBonus {
        public static final Codec<TreasureGoblinBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(TreasureGoblinBonus.gemClass(), (App)LootRarity.mapCodec(Data.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, TreasureGoblinBonus::new));
        protected final Map<LootRarity, Data> values;

        public TreasureGoblinBonus(GemClass gemClass, Map<LootRarity, Data> values) {
            super(Apotheosis.loc("twilight_treasure_goblin"), gemClass);
            this.values = values;
        }

        @Override
        public void doPostAttack(ItemStack gem, LootRarity rarity, LivingEntity user, Entity target) {
            Data d = this.values.get(rarity);
            if (Affix.isOnCooldown(this.getCooldownId(gem), d.cooldown, user)) {
                return;
            }
            if (user.f_19796_.m_188501_() <= d.chance) {
                Redcap goblin = (Redcap)((EntityType)REDCAP.get()).m_20615_(user.m_9236_());
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("DeathLootTable", "apotheosis:entity/treasure_goblin");
                goblin.m_7378_(tag);
                goblin.getPersistentData().m_128379_("apoth.treasure_goblin", true);
                goblin.m_6593_((Component)Component.m_237115_((String)"name.apotheosis.treasure_goblin").m_130938_(s -> s.m_131148_((TextColor)GradientColor.RAINBOW)));
                goblin.m_20340_(true);
                goblin.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("apoth.very_fast", 0.2, AttributeModifier.Operation.ADDITION));
                goblin.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("apoth.healmth", 60.0, AttributeModifier.Operation.ADDITION));
                goblin.m_21153_(goblin.m_21233_());
                for (int i = 0; i < 8; ++i) {
                    int x = Mth.m_216271_((RandomSource)goblin.f_19796_, (int)-5, (int)5);
                    int y = Mth.m_216271_((RandomSource)goblin.f_19796_, (int)-1, (int)1);
                    int z = Mth.m_216271_((RandomSource)goblin.f_19796_, (int)-5, (int)5);
                    goblin.m_146884_(target.m_20182_().m_82520_((double)x, (double)y, (double)z));
                    if (user.m_9236_().m_45786_((Entity)goblin)) break;
                    if (i != 7) continue;
                    goblin.m_146884_(target.m_20182_());
                }
                goblin.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0));
                user.m_9236_().m_7967_((Entity)goblin);
                Affix.startCooldown(this.getCooldownId(gem), user);
            }
        }

        public Codec<? extends GemBonus> getCodec() {
            return CODEC;
        }

        @Override
        public GemBonus validate() {
            Preconditions.checkArgument((!this.values.isEmpty() ? 1 : 0) != 0, (Object)"No values provided!");
            return this;
        }

        @Override
        public boolean supports(LootRarity rarity) {
            return this.values.containsKey(rarity);
        }

        @Override
        public int getNumberOfUUIDs() {
            return 0;
        }

        @Override
        public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
            Data d = this.values.get(rarity);
            MutableComponent cooldown = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)d.cooldown)});
            return Component.m_237110_((String)("bonus." + String.valueOf(this.getId()) + ".desc"), (Object[])new Object[]{Affix.fmt(d.chance * 100.0f), cooldown}).m_130940_(ChatFormatting.YELLOW);
        }

        protected record Data(float chance, int cooldown) {
            public static final Codec<Data> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("chance").forGetter(Data::chance), (App)Codec.INT.fieldOf("cooldown").forGetter(Data::cooldown)).apply((Applicative)inst, Data::new));
        }
    }

    public static class FortificationBonus
    extends GemBonus {
        public static final Codec<FortificationBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(FortificationBonus.gemClass(), (App)LootRarity.mapCodec(Data.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, FortificationBonus::new));
        protected final Map<LootRarity, Data> values;

        public FortificationBonus(GemClass gemClass, Map<LootRarity, Data> values) {
            super(Apotheosis.loc("twilight_fortification"), gemClass);
            this.values = values;
        }

        @Override
        public void doPostHurt(ItemStack gem, LootRarity rarity, LivingEntity user, Entity attacker) {
            Data d = this.values.get(rarity);
            if (Affix.isOnCooldown(this.getCooldownId(gem), d.cooldown, user)) {
                return;
            }
            if (user.f_19796_.m_188501_() <= d.chance) {
                user.getCapability(CapabilityList.SHIELDS).ifPresent(cap -> cap.replenishShields());
                Affix.startCooldown(this.getCooldownId(gem), user);
            }
        }

        public Codec<? extends GemBonus> getCodec() {
            return CODEC;
        }

        @Override
        public GemBonus validate() {
            Preconditions.checkArgument((!this.values.isEmpty() ? 1 : 0) != 0, (Object)"No values provided!");
            return this;
        }

        @Override
        public boolean supports(LootRarity rarity) {
            return this.values.containsKey(rarity);
        }

        @Override
        public int getNumberOfUUIDs() {
            return 0;
        }

        @Override
        public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
            Data d = this.values.get(rarity);
            MutableComponent cooldown = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)d.cooldown)});
            return Component.m_237110_((String)("bonus." + String.valueOf(this.getId()) + ".desc"), (Object[])new Object[]{Affix.fmt(d.chance * 100.0f), cooldown}).m_130940_(ChatFormatting.YELLOW);
        }

        protected record Data(float chance, int cooldown) {
            public static final Codec<Data> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("chance").forGetter(Data::chance), (App)Codec.INT.fieldOf("cooldown").forGetter(Data::cooldown)).apply((Applicative)inst, Data::new));
        }
    }
}

