/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.gen;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemRegistry;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ItemFrameGemsProcessor
extends StructureProcessor {
    public static final Codec<ItemFrameGemsProcessor> CODEC = Codec.unit((Object)((Object)new ItemFrameGemsProcessor(null)));
    protected final ResourceLocation lootTable;

    public ItemFrameGemsProcessor(ResourceLocation lootTable) {
        this.lootTable = lootTable;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)Adventure.Features.ITEM_FRAME_GEMS.get();
    }

    public StructureTemplate.StructureEntityInfo processEntity(LevelReader world, BlockPos seedPos, StructureTemplate.StructureEntityInfo rawEntityInfo, StructureTemplate.StructureEntityInfo entityInfo, StructurePlaceSettings placementSettings, StructureTemplate template) {
        CompoundTag entityNBT = entityInfo.f_74685_;
        String id = entityNBT.m_128461_("id");
        if (world instanceof ServerLevelAccessor) {
            ServerLevelAccessor sla = (ServerLevelAccessor)world;
            if ("minecraft:item_frame".equals(id)) {
                this.writeEntityNBT(sla.m_6018_(), entityInfo.f_74684_, placementSettings.m_230326_(entityInfo.f_74684_), entityNBT, placementSettings);
            }
        }
        return entityInfo;
    }

    protected void writeEntityNBT(ServerLevel world, BlockPos pos, RandomSource rand, CompoundTag nbt, StructurePlaceSettings settings) {
        ItemStack stack = GemRegistry.createRandomGemStack(rand, world, 0.0f, WeightedDynamicRegistry.IDimensional.matches((Level)world));
        nbt.m_128365_("Item", (Tag)stack.serializeNBT());
        nbt.m_128405_("TileX", pos.m_123341_());
        nbt.m_128405_("TileY", pos.m_123342_());
        nbt.m_128405_("TileZ", pos.m_123343_());
    }
}

