/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.spawner.RogueSpawner;
import dev.shadowsoffire.apotheosis.adventure.spawner.RogueSpawnerRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class RogueSpawnerFeature
extends Feature<Config> {
    public static final RuleTest STONE_TEST = new TagMatchTest(BlockTags.f_13061_);

    public RogueSpawnerFeature() {
        super(Config.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> ctx) {
        WorldGenLevel world = ctx.m_159774_();
        if (!AdventureConfig.canGenerateIn(world)) {
            return false;
        }
        BlockPos pos = ctx.m_159777_();
        RandomSource rand = ctx.m_225041_();
        if (rand.m_188501_() <= ((Config)ctx.m_159778_()).successChance()) {
            BlockState state = world.m_8055_(pos);
            BlockState downState = world.m_8055_(pos.m_7495_());
            BlockState upState = world.m_8055_(pos.m_7494_());
            if (STONE_TEST.m_213865_(downState, rand) && upState.m_60795_() && (state.m_60795_() || STONE_TEST.m_213865_(state, rand))) {
                RogueSpawner item = (RogueSpawner)RogueSpawnerRegistry.INSTANCE.getRandomItem(rand);
                if (item == null) {
                    return false;
                }
                item.place(world, pos, rand);
                AdventureModule.debugLog(pos, "Rogue Spawner - " + String.valueOf(RogueSpawnerRegistry.INSTANCE.getKey(item)));
                return true;
            }
        }
        return false;
    }

    public record Config(float successChance) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("success_chance").forGetter(Config::successChance)).apply((Applicative)inst, Config::new));
    }
}

