/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class AffixConvertLootModifier
extends LootModifier {
    public static final Codec<AffixConvertLootModifier> CODEC = RecordCodecBuilder.create(inst -> AffixConvertLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AffixConvertLootModifier::new));

    protected AffixConvertLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!Apotheosis.enableAdventure) {
            return generatedLoot;
        }
        for (AdventureConfig.LootPatternMatcher m : AdventureConfig.AFFIX_CONVERT_LOOT_RULES) {
            if (!m.matches(context.getQueriedLootTableId())) continue;
            RarityClamp rarities = AdventureConfig.AFFIX_CONVERT_RARITIES.get(context.m_78952_().m_46472_().m_135782_());
            RandomSource rand = context.m_230907_();
            float luck = context.m_78945_();
            for (ItemStack s : generatedLoot) {
                if (LootCategory.forItem(s).isNone() || !AffixHelper.getAffixes(s).isEmpty() || !(rand.m_188501_() <= m.chance())) continue;
                LootController.createLootItem(s, LootRarity.random(rand, luck, rarities), rand);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

