/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.table;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.ench.EnchModule;
import dev.shadowsoffire.apotheosis.ench.api.IEnchantingBlock;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantingStatRegistry
extends DynamicRegistry<BlockStats> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final EnchantingStatRegistry INSTANCE = new EnchantingStatRegistry();
    private final Map<Block, Stats> statsPerBlock = new HashMap<Block, Stats>();
    private float absoluteMaxEterna = 50.0f;

    protected EnchantingStatRegistry() {
        super(EnchModule.LOGGER, "enchanting_stats", true, false);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Apotheosis.loc("enchanting_stats"), BlockStats.CODEC);
    }

    protected void beginReload() {
        super.beginReload();
        this.statsPerBlock.clear();
    }

    protected void onReload() {
        super.onReload();
        for (BlockStats bStats : this.registry.values()) {
            bStats.blocks.forEach(b -> this.statsPerBlock.put((Block)b, bStats.stats));
        }
        this.computeAbsoluteMaxEterna();
    }

    public static float getEterna(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).eterna;
        }
        return state.getEnchantPowerBonus((LevelReader)world, pos);
    }

    public static float getMaxEterna(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).maxEterna;
        }
        return ((IEnchantingBlock)block).getMaxEnchantingPower(state, (LevelReader)world, pos);
    }

    public static float getQuanta(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).quanta;
        }
        return ((IEnchantingBlock)block).getQuantaBonus(state, (LevelReader)world, pos);
    }

    public static float getArcana(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).arcana;
        }
        return ((IEnchantingBlock)block).getArcanaBonus(state, (LevelReader)world, pos);
    }

    public static float getQuantaRectification(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).rectification;
        }
        return ((IEnchantingBlock)block).getQuantaRectification(state, (LevelReader)world, pos);
    }

    public static int getBonusClues(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).clues;
        }
        return ((IEnchantingBlock)block).getBonusClues(state, (LevelReader)world, pos);
    }

    public static float getAbsoluteMaxEterna() {
        return EnchantingStatRegistry.INSTANCE.absoluteMaxEterna;
    }

    private void computeAbsoluteMaxEterna() {
        this.absoluteMaxEterna = this.registry.values().stream().max(Comparator.comparingDouble((ToDoubleFunction<BlockStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$computeAbsoluteMaxEterna$1(dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry$BlockStats ), (Ldev/shadowsoffire/apotheosis/ench/table/EnchantingStatRegistry$BlockStats;)D)())).get().stats.maxEterna;
    }

    private static /* synthetic */ double lambda$computeAbsoluteMaxEterna$1(BlockStats s) {
        return s.stats.maxEterna;
    }

    public static class BlockStats
    implements CodecProvider<BlockStats> {
        public static Codec<BlockStats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.nullableField((Codec)Codec.list((Codec)ForgeRegistries.BLOCKS.getCodec()), (String)"blocks", Collections.emptyList()).forGetter(bs -> bs.blocks), (App)PlaceboCodecs.nullableField((Codec)TagKey.m_203877_((ResourceKey)Registries.f_256747_), (String)"tag").forGetter(bs -> Optional.empty()), (App)PlaceboCodecs.nullableField((Codec)ForgeRegistries.BLOCKS.getCodec(), (String)"block").forGetter(bs -> Optional.empty()), (App)Stats.CODEC.fieldOf("stats").forGetter(bs -> bs.stats)).apply((Applicative)inst, BlockStats::new));
        public final List<Block> blocks = new ArrayList<Block>();
        public final Stats stats;

        public BlockStats(List<Block> blocks, Optional<TagKey<Block>> tag, Optional<Block> block, Stats stats) {
            if (!blocks.isEmpty()) {
                this.blocks.addAll(blocks);
            }
            if (tag.isPresent()) {
                this.blocks.addAll(INSTANCE.getContext().getTag(tag.get()).stream().map(Holder::m_203334_).toList());
            }
            if (block.isPresent()) {
                this.blocks.add(block.get());
            }
            this.stats = stats;
        }

        public Codec<? extends BlockStats> getCodec() {
            return CODEC;
        }
    }

    public record Stats(float maxEterna, float eterna, float quanta, float arcana, float rectification, int clues) {
        public static Codec<Stats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.nullableField((Codec)Codec.FLOAT, (String)"maxEterna", (Object)Float.valueOf(15.0f)).forGetter(Stats::maxEterna), (App)PlaceboCodecs.nullableField((Codec)Codec.FLOAT, (String)"eterna", (Object)Float.valueOf(0.0f)).forGetter(Stats::eterna), (App)PlaceboCodecs.nullableField((Codec)Codec.FLOAT, (String)"quanta", (Object)Float.valueOf(0.0f)).forGetter(Stats::quanta), (App)PlaceboCodecs.nullableField((Codec)Codec.FLOAT, (String)"arcana", (Object)Float.valueOf(0.0f)).forGetter(Stats::arcana), (App)PlaceboCodecs.nullableField((Codec)Codec.FLOAT, (String)"rectification", (Object)Float.valueOf(0.0f)).forGetter(Stats::rectification), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"clues", (Object)0).forGetter(Stats::clues)).apply((Applicative)inst, Stats::new));

        public void write(FriendlyByteBuf buf) {
            buf.writeFloat(this.maxEterna);
            buf.writeFloat(this.eterna);
            buf.writeFloat(this.quanta);
            buf.writeFloat(this.arcana);
            buf.writeFloat(this.rectification);
            buf.writeByte(this.clues);
        }

        public static Stats read(FriendlyByteBuf buf) {
            return new Stats(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readByte());
        }
    }
}

