/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.spawn.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.spawn.modifiers.SpawnerStat;
import dev.shadowsoffire.apotheosis.spawn.modifiers.StatModifier;
import dev.shadowsoffire.apotheosis.spawn.spawner.ApothSpawnerBlock;
import dev.shadowsoffire.apotheosis.spawn.spawner.ApothSpawnerTile;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SpawnerStats {
    public static final Map<String, SpawnerStat<?>> REGISTRY = new LinkedHashMap();
    public static final SpawnerStat<Short> MIN_DELAY = SpawnerStats.register(new ShortStat("min_delay", s -> s.f_59788_.f_45447_, (s, v) -> {
        s.f_59788_.f_45447_ = v.shortValue();
    }));
    public static final SpawnerStat<Short> MAX_DELAY = SpawnerStats.register(new ShortStat("max_delay", s -> s.f_59788_.f_45448_, (s, v) -> {
        s.f_59788_.f_45448_ = v.shortValue();
    }));
    public static final SpawnerStat<Short> SPAWN_COUNT = SpawnerStats.register(new ShortStat("spawn_count", s -> s.f_59788_.f_45449_, (s, v) -> {
        s.f_59788_.f_45449_ = v.shortValue();
    }));
    public static final SpawnerStat<Short> MAX_NEARBY_ENTITIES = SpawnerStats.register(new ShortStat("max_nearby_entities", s -> s.f_59788_.f_45451_, (s, v) -> {
        s.f_59788_.f_45451_ = v.shortValue();
    }));
    public static final SpawnerStat<Short> REQ_PLAYER_RANGE = SpawnerStats.register(new ShortStat("req_player_range", s -> s.f_59788_.f_45452_, (s, v) -> {
        s.f_59788_.f_45452_ = v.shortValue();
    }));
    public static final SpawnerStat<Short> SPAWN_RANGE = SpawnerStats.register(new ShortStat("spawn_range", s -> s.f_59788_.f_45453_, (s, v) -> {
        s.f_59788_.f_45453_ = v.shortValue();
    }));
    public static final SpawnerStat<Boolean> IGNORE_PLAYERS = SpawnerStats.register(new BoolStat("ignore_players", s -> s.ignoresPlayers, (s, v) -> {
        s.ignoresPlayers = v;
    }));
    public static final SpawnerStat<Boolean> IGNORE_CONDITIONS = SpawnerStats.register(new BoolStat("ignore_conditions", s -> s.ignoresConditions, (s, v) -> {
        s.ignoresConditions = v;
    }));
    public static final SpawnerStat<Boolean> REDSTONE_CONTROL = SpawnerStats.register(new BoolStat("redstone_control", s -> s.redstoneControl, (s, v) -> {
        s.redstoneControl = v;
    }));
    public static final SpawnerStat<Boolean> IGNORE_LIGHT = SpawnerStats.register(new BoolStat("ignore_light", s -> s.ignoresLight, (s, v) -> {
        s.ignoresLight = v;
    }));
    public static final SpawnerStat<Boolean> NO_AI = SpawnerStats.register(new BoolStat("no_ai", s -> s.hasNoAI, (s, v) -> {
        s.hasNoAI = v;
    }));
    public static final SpawnerStat<Boolean> SILENT = SpawnerStats.register(new BoolStat("silent", s -> s.silent, (s, v) -> {
        s.silent = v;
    }));
    public static final SpawnerStat<Boolean> BABY = SpawnerStats.register(new BoolStat("baby", s -> s.baby, (s, v) -> {
        s.baby = v;
    }));

    public static void generateTooltip(ApothSpawnerTile tile, Consumer<Component> list) {
        for (SpawnerStat<?> stat : REGISTRY.values()) {
            Component comp = stat.getTooltip(tile);
            if (comp.getString().isEmpty()) continue;
            list.accept(comp);
        }
    }

    private static <T extends SpawnerStat<?>> T register(T t) {
        REGISTRY.put(t.getId(), t);
        return t;
    }

    private static class ShortStat
    extends Base<Short> {
        public static final Codec<Short> BOUNDS_CODEC = Codec.intRange((int)-1, (int)Short.MAX_VALUE).xmap(Integer::shortValue, Short::intValue);
        private final Codec<StatModifier<Short>> modifierCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.SHORT.fieldOf("value").forGetter(StatModifier::value), (App)BOUNDS_CODEC.fieldOf("min").forGetter(StatModifier::min), (App)BOUNDS_CODEC.fieldOf("max").forGetter(StatModifier::max)).apply((Applicative)inst, (value, min, max) -> new StatModifier<Short>(this, (Short)value, min == -1 ? (short)0 : min, max == -1 ? (short)Short.MAX_VALUE : (short)max)));

        private ShortStat(String id, Function<ApothSpawnerTile, Integer> getter, BiConsumer<ApothSpawnerTile, Short> setter) {
            super(id, (ApothSpawnerTile tile) -> ((Integer)getter.apply((ApothSpawnerTile)((Object)tile))).shortValue(), setter);
        }

        @Override
        public Codec<StatModifier<Short>> getModifierCodec() {
            return this.modifierCodec;
        }

        @Override
        public Component getTooltip(ApothSpawnerTile spawner) {
            return ApothSpawnerBlock.concat(this.name(), this.getValue(spawner));
        }

        @Override
        public boolean apply(Short value, Short min, Short max, ApothSpawnerTile spawner) {
            short old = (Short)this.getter.apply(spawner);
            this.setter.accept(spawner, (short)Mth.m_14045_((int)(old + value), (int)min.shortValue(), (int)max.shortValue()));
            return old != (Short)this.getter.apply(spawner);
        }
    }

    private static class BoolStat
    extends Base<Boolean> {
        private final Codec<StatModifier<Boolean>> modifierCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.fieldOf("value").forGetter(StatModifier::value)).apply((Applicative)inst, value -> new StatModifier<Boolean>(this, (Boolean)value, false, true)));

        private BoolStat(String id, Function<ApothSpawnerTile, Boolean> getter, BiConsumer<ApothSpawnerTile, Boolean> setter) {
            super(id, getter, setter);
        }

        @Override
        public Codec<StatModifier<Boolean>> getModifierCodec() {
            return this.modifierCodec;
        }

        @Override
        public Component getTooltip(ApothSpawnerTile spawner) {
            return (Boolean)this.getValue(spawner) != false ? this.name().m_130940_(ChatFormatting.DARK_GREEN) : CommonComponents.f_237098_;
        }

        @Override
        public boolean apply(Boolean value, Boolean min, Boolean max, ApothSpawnerTile spawner) {
            boolean old = (Boolean)this.getter.apply(spawner);
            this.setter.accept(spawner, value);
            return old != (Boolean)this.getter.apply(spawner);
        }
    }

    private static abstract class Base<T>
    implements SpawnerStat<T> {
        protected final String id;
        protected final Function<ApothSpawnerTile, T> getter;
        protected final BiConsumer<ApothSpawnerTile, T> setter;

        private Base(String id, Function<ApothSpawnerTile, T> getter, BiConsumer<ApothSpawnerTile, T> setter) {
            this.id = id;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public T getValue(ApothSpawnerTile spawner) {
            return this.getter.apply(spawner);
        }
    }
}

