/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class GemIngredient
extends AbstractIngredient {
    protected final DynamicHolder<LootRarity> rarity;
    protected ItemStack[] items;

    public GemIngredient(DynamicHolder<LootRarity> rarity) {
        super(Stream.empty());
        this.rarity = rarity;
    }

    public boolean test(ItemStack stack) {
        DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(stack);
        return stack.m_41720_() == Adventure.Items.GEM.get() && rarity.isBound() && rarity == this.rarity;
    }

    public ItemStack[] m_43908_() {
        if (this.items == null) {
            Collection gems = GemRegistry.INSTANCE.getValues();
            if (gems.size() == 0) {
                return new ItemStack[0];
            }
            this.items = new ItemStack[gems.size()];
            int i = 0;
            for (Gem g : GemRegistry.INSTANCE.getValues()) {
                this.items[i++] = GemRegistry.createGemStack(g, (LootRarity)this.rarity.get());
            }
        }
        return this.items;
    }

    protected void invalidate() {
        super.invalidate();
        this.items = null;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        return new JsonObject();
    }

    public LootRarity getRarity() {
        return (LootRarity)this.rarity.get();
    }

    public static class Serializer
    implements IIngredientSerializer<GemIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public GemIngredient parse(FriendlyByteBuf buffer) {
            DynamicHolder rarity = RarityRegistry.INSTANCE.holder(buffer.m_130281_());
            return new GemIngredient((DynamicHolder<LootRarity>)rarity);
        }

        public GemIngredient parse(JsonObject json) {
            DynamicHolder rarity = RarityRegistry.INSTANCE.holder(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"rarity")));
            return new GemIngredient((DynamicHolder<LootRarity>)rarity);
        }

        public void write(FriendlyByteBuf buffer, GemIngredient ingredient) {
            buffer.m_130085_(ingredient.rarity.getId());
        }
    }
}

