/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.apiimpl.teleportation;

import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftoolsbase.api.teleportation.ITeleportationManager;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TeleportationManager
implements ITeleportationManager {
    public String getReceiverName(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_60734_() == TeleporterModule.MATTER_RECEIVER.get()) {
            MatterReceiverTileEntity te = (MatterReceiverTileEntity)world.m_7702_(pos);
            return te.getName();
        }
        return null;
    }

    public boolean createReceiver(Level world, BlockPos pos, String name, int power) {
        world.m_7731_(pos, ((BaseBlock)TeleporterModule.MATTER_RECEIVER.get()).m_49966_(), 2);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof MatterReceiverTileEntity) {
            MatterReceiverTileEntity te = (MatterReceiverTileEntity)blockEntity;
            if (power == -1) {
                te.storeEnergy(((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get()).intValue());
            } else {
                te.storeEnergy(Math.min(power, (Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get()));
            }
            te.setName(name);
            te.m_6596_();
            this.registerReceiver(world, pos, name);
        }
        return true;
    }

    private void registerReceiver(Level world, BlockPos pos, String name) {
        TeleportDestinations destinations = TeleportDestinations.get(world);
        GlobalPos gc = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos);
        TeleportDestination destination = destinations.addDestination(gc);
        destination.setName(name);
        destinations.save();
    }

    public void teleportPlayer(Player player, ResourceKey<Level> dimension, BlockPos location) {
        TeleportationTools.teleportToDimension((Player)player, dimension, (double)location.m_123341_(), (double)location.m_123342_(), (double)location.m_123343_());
    }

    public void removeReceiverDestinations(Level world, ResourceKey<Level> dim) {
        TeleportDestinations destinations = TeleportDestinations.get(world);
        destinations.removeDestinationsInDimension(dim);
        destinations.save();
    }
}

