/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.compat;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.ITooltipInfo;
import mcjty.rftoolsutility.compat.TheOneProbeSupport;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneChannelBlock;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneReceiverTileEntity;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.modules.logic.tools.SensorType;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RFToolsUtilityTOPDriver
implements TOPDriver {
    public static final RFToolsUtilityTOPDriver DRIVER = new RFToolsUtilityTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        Block block = blockState.m_60734_();
        ResourceLocation id = Tools.getId((Block)block);
        if (!this.drivers.containsKey(id)) {
            if (block instanceof ScreenBlock) {
                this.drivers.put(id, new ScreenDriver());
            } else if (block == TeleporterModule.MATTER_RECEIVER.get()) {
                this.drivers.put(id, new MatterReceiverDriver());
            } else if (block == TeleporterModule.MATTER_TRANSMITTER.get()) {
                this.drivers.put(id, new MatterTransmitterDriver());
            } else if (block == TeleporterModule.SIMPLE_DIALER.get()) {
                this.drivers.put(id, new SimpleDialerDriver());
            } else if (block == LogicBlockModule.COUNTER.get()) {
                this.drivers.put(id, new CounterDriver());
            } else if (block == LogicBlockModule.INVCHECKER.get()) {
                this.drivers.put(id, new InvCheckerDriver());
            } else if (block == LogicBlockModule.SENSOR.get()) {
                this.drivers.put(id, new SensorDriver());
            } else if (block == LogicBlockModule.SEQUENCER.get()) {
                this.drivers.put(id, new SequencerDriver());
            } else if (block == LogicBlockModule.TIMER.get()) {
                this.drivers.put(id, new TimerDriver());
            } else if (block == LogicBlockModule.DIGIT.get()) {
                this.drivers.put(id, new DigitDriver());
            } else if (block == SpawnerModule.MATTER_BEAMER.get()) {
                this.drivers.put(id, new MatterBeamerDriver());
            } else if (block == SpawnerModule.SPAWNER.get()) {
                this.drivers.put(id, new SpawnerDriver());
            } else if (block == EnvironmentalModule.ENVIRONENTAL_CONTROLLER.get()) {
                this.drivers.put(id, new EnvironmentalDriver());
            } else if (block instanceof RedstoneChannelBlock) {
                this.drivers.put(id, new RedstoneChannelDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    public static class ScreenDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                IScreenModule<?> module;
                if (!te.isConnected() && te.isControllerNeeded()) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text("[NOT CONNECTED]"));
                }
                if (!te.isCreative()) {
                    boolean power = te.isPowerOn();
                    if (!power) {
                        probeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text("[NO POWER]"));
                    }
                    if (mode == ProbeMode.EXTENDED) {
                        int rfPerTick = te.getTotalRfPerTick();
                        probeInfo.text(CompoundText.createLabelInfo((String)(power ? "Consuming " : "Needs "), (Object)(rfPerTick + " RF/tick")));
                    }
                }
                if ((module = te.getHoveringModule()) instanceof ITooltipInfo) {
                    List info = ((ITooltipInfo)module).getInfo(world, te.getHoveringX(), te.getHoveringY());
                    for (String s : info) {
                        probeInfo.text(CompoundText.create().text(s));
                    }
                }
            });
        }
    }

    public static class MatterReceiverDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                String name = te.getName();
                int id = te.getId();
                if (name == null || name.isEmpty()) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.INFO).text((String)(id == -1 ? "" : "Id: " + id)));
                } else {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.INFO).text("Name: " + name + (String)(id == -1 ? "" : ", Id: " + id)));
                }
            });
        }
    }

    public static class MatterTransmitterDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                probeInfo.text(CompoundText.createLabelInfo((String)"Name: ", (Object)te.getName()));
                if (te.isDialed()) {
                    Integer teleportId = te.getTeleportId();
                    TeleportDestinations destinations = TeleportDestinations.get(world);
                    String name = "?";
                    if (teleportId != null) {
                        name = TeleportDestinations.getDestinationName(destinations, teleportId);
                    }
                    probeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text("[DIALED to " + name + "]"));
                }
                if (te.isOnce()) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text("[ONCE]"));
                }
            });
        }
    }

    public static class SimpleDialerDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                Integer receiver;
                GlobalPos trans = te.getTransmitter();
                if (trans != null) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Transmitter at: ", (Object)(BlockPosTools.toString((BlockPos)trans.m_122646_()) + " (dim " + trans.m_122640_().m_135782_().toString() + ")")));
                }
                if ((receiver = te.getReceiver()) != null) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Receiver: ", (Object)receiver));
                }
                if (te.isOnceMode()) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.INFO).text("Dial Once mode enabled"));
                }
            });
        }
    }

    public static class CounterDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> probeInfo.text(CompoundText.createLabelInfo((String)"Current: ", (Object)te.getCurrent())));
        }
    }

    public static class InvCheckerDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                boolean rc = te.checkOutput();
                probeInfo.text(CompoundText.createLabelInfo((String)"Output: ", (Object)(rc ? "on" : "off")));
            });
        }
    }

    public static class SensorDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                SensorType sensorType = te.getSensorType();
                if (sensorType.isSupportsNumber()) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Type: ", (Object)(sensorType.getName() + " (" + te.getNumber() + ")")));
                } else {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Type: ", (Object)sensorType.getName()));
                }
                int blockCount = te.getAreaType().getBlockCount();
                if (blockCount == 1) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Area: ", (Object)"1 block"));
                } else if (blockCount < 0) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Area: ", (Object)(-blockCount + "x" + -blockCount + " blocks")));
                } else {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Area: ", (Object)(blockCount + " blocks")));
                }
                boolean rc = te.checkSensor();
                probeInfo.text(CompoundText.createLabelInfo((String)"Output: ", (Object)(rc ? "on" : "off")));
            });
        }
    }

    public static class SequencerDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                IProbeInfo horizontal = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                horizontal.text(CompoundText.createLabelInfo((String)"Mode: ", (Object)te.getMode().getName()));
                TheOneProbeSupport.addSequenceElement(horizontal, te.getCycleBits(), te.getCurrentStep(), mode == ProbeMode.EXTENDED);
                int currentStep = te.getCurrentStep();
                boolean rc = te.checkOutput();
                probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Step: ").style(TextStyleClass.INFO).text(String.valueOf(currentStep)).style(TextStyleClass.LABEL).text(" -> ").style(TextStyleClass.INFO).text(rc ? "on" : "off"));
            });
        }
    }

    public static class TimerDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> probeInfo.text(CompoundText.createLabelInfo((String)"Time: ", (Object)te.getTimer())));
        }
    }

    public static class DigitDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> probeInfo.text(CompoundText.createLabelInfo((String)"Power: ", (Object)te.getPowerLevel())));
        }
    }

    public static class MatterBeamerDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                BlockPos coordinate = te.getDestination();
                if (coordinate == null) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Not connected to a spawner!"));
                } else {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.INFO).text("Connected!"));
                }
                probeInfo.text(CompoundText.createLabelInfo((String)"Power: ", (Object)te.getPowerLevel()));
            });
        }
    }

    public static class SpawnerDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                float[] matter = te.getMatter();
                DecimalFormat fmt = new DecimalFormat("#.##");
                fmt.setRoundingMode(RoundingMode.DOWN);
                probeInfo.text(CompoundText.createLabelInfo((String)"Key Matter: ", (Object)fmt.format(matter[0])));
                probeInfo.text(CompoundText.createLabelInfo((String)"Bulk Matter: ", (Object)fmt.format(matter[1])));
                probeInfo.text(CompoundText.createLabelInfo((String)"Living Matter: ", (Object)fmt.format(matter[2])));
            });
        }
    }

    public static class EnvironmentalDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                int rfPerTick = te.getTotalRfPerTick();
                int volume = te.getVolume();
                if (te.isActive()) {
                    probeInfo.text(ChatFormatting.GREEN + "Active " + rfPerTick + " RF/tick (#" + volume + ")");
                } else {
                    probeInfo.text(ChatFormatting.GREEN + "Inactive (#" + volume + ")");
                }
                int radius = te.getRadius();
                int miny = te.getMiny();
                int maxy = te.getMaxy();
                probeInfo.text(ChatFormatting.GREEN + "Area: radius " + radius + " (" + miny + "/" + maxy + ")");
            });
        }
    }

    public static class RedstoneChannelDriver
    extends DefaultDriver {
        @Override
        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                int channel = te.getChannel(false);
                if (channel == -1) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text("No channel set! Right-click with another"));
                    probeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text("transmitter or receiver to pair"));
                } else {
                    RedstoneChannels.RedstoneChannel c = RedstoneChannels.getChannels(world).getChannel(channel);
                    if (c != null && !c.getName().isEmpty()) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Channel: ", (Object)(channel + " (" + c.getName() + ")")));
                    } else {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Channel: ", (Object)channel));
                    }
                }
                if (te instanceof RedstoneReceiverTileEntity) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"Analog mode: ", (Object)((RedstoneReceiverTileEntity)((Object)te)).getAnalog()));
                    probeInfo.text(CompoundText.createLabelInfo((String)"Output: ", (Object)((RedstoneReceiverTileEntity)((Object)te)).checkOutput()));
                }
            });
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

