/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneChannelTileEntity;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneReceiverTileEntity;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationItem;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.modules.screen.items.modules.ButtonModuleItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class RedstoneChannelBlock
extends LogicSlabBlock {
    public RedstoneChannelBlock(BlockBuilder builder) {
        super(builder);
    }

    protected static String getChannelString(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, (info, s) -> Integer.toString(info.m_128451_(s)), (String)"channel", (Object)"<unset>");
    }

    private boolean isRedstoneChannelItem(Item item) {
        return item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof RedstoneChannelBlock || item instanceof ButtonModuleItem || item instanceof RedstoneInformationItem;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState blockState, BlockEntityType<T> blockEntityType) {
        if (!world.m_5776_()) {
            return (pLevel, pPos, pState, pBlockEntity) -> {
                if (pBlockEntity instanceof RedstoneReceiverTileEntity) {
                    RedstoneReceiverTileEntity tile = (RedstoneReceiverTileEntity)pBlockEntity;
                    tile.tickServer();
                }
            };
        }
        return null;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        BlockEntity te;
        ItemStack stack = player.m_21120_(hand);
        if (this.isRedstoneChannelItem(stack.m_41720_()) && (te = world.m_7702_(pos)) instanceof RedstoneChannelTileEntity) {
            if (!world.f_46443_) {
                RedstoneChannelTileEntity rcte = (RedstoneChannelTileEntity)te;
                if (stack.m_41720_() instanceof RedstoneInformationItem) {
                    int channel = rcte.getChannel(false);
                    if (channel != -1) {
                        if (RedstoneInformationItem.addChannel(stack, channel)) {
                            Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Added channel " + channel + "!"));
                        } else {
                            Logging.message((Player)player, (String)(ChatFormatting.RED + "Channel " + channel + " was already added!"));
                        }
                    } else {
                        Logging.message((Player)player, (String)(ChatFormatting.RED + "Block has no channel yet!"));
                    }
                } else if (stack.m_41720_() instanceof ButtonModuleItem) {
                    int channel;
                    if (!player.m_6047_()) {
                        channel = rcte.getChannel(true);
                        stack.m_41784_().m_128405_("channel", channel);
                    } else {
                        channel = ButtonModuleItem.getChannel(stack);
                        if (channel == -1) {
                            RedstoneChannels redstoneChannels = RedstoneChannels.getChannels(world);
                            channel = redstoneChannels.newChannel();
                            redstoneChannels.save();
                            stack.m_41784_().m_128405_("channel", channel);
                        }
                        rcte.setChannel(channel);
                    }
                    Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Channel set to " + channel + "!"));
                } else {
                    int channel;
                    if (!player.m_6047_()) {
                        channel = rcte.getChannel(true);
                        NBTTools.setInfoNBT((ItemStack)stack, CompoundTag::m_128405_, (String)"channel", (Object)channel);
                    } else {
                        channel = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"channel", (Object)-1);
                        if (channel == -1) {
                            RedstoneChannels redstoneChannels = RedstoneChannels.getChannels(world);
                            channel = redstoneChannels.newChannel();
                            redstoneChannels.save();
                            NBTTools.setInfoNBT((ItemStack)stack, CompoundTag::m_128405_, (String)"channel", (Object)channel);
                        }
                        rcte.setChannel(channel);
                    }
                    Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Channel set to " + channel + "!"));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, result);
    }
}

