/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.LogicFacing;
import mcjty.lib.varia.NamedEnum;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.tools.AreaType;
import mcjty.rftoolsutility.modules.logic.tools.GroupType;
import mcjty.rftoolsutility.modules.logic.tools.SensorType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class SensorTileEntity
extends TickingTileEntity {
    private final LogicSupport support = new LogicSupport();
    public static final int SLOT_ITEMMATCH = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.ghost(), 0, 154, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid(GenericItemHandler.no()).build();
    @Cap(type=CapType.CONTAINER)
    private LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Sensor").containerSupplier(DefaultContainerProvider.container(LogicBlockModule.CONTAINER_SENSOR, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @GuiValue
    private int number = 0;
    private SensorType sensorType = SensorType.SENSOR_BLOCK;
    @GuiValue
    public static final Value<SensorTileEntity, String> VALUE_TYPE = Value.createEnum((String)"type", (NamedEnum[])SensorType.values(), SensorTileEntity::getSensorType, SensorTileEntity::setSensorType);
    private AreaType areaType = AreaType.AREA_1;
    @GuiValue
    public static final Value<SensorTileEntity, String> VALUE_AREA = Value.createEnum((String)"area", (NamedEnum[])AreaType.values(), SensorTileEntity::getAreaType, SensorTileEntity::setAreaType);
    private GroupType groupType = GroupType.GROUP_ONE;
    @GuiValue
    public static final Value<SensorTileEntity, String> VALUE_GROUP = Value.createEnum((String)"group", (NamedEnum[])GroupType.values(), SensorTileEntity::getGroupType, SensorTileEntity::setGroupType);
    private int checkCounter = 0;
    private AABB cachedBox = null;

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/sensor")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(SensorTileEntity::new));
    }

    public SensorTileEntity(BlockPos pos, BlockState state) {
        super(LogicBlockModule.TYPE_SENSOR.get(), pos, state);
    }

    public int getNumber() {
        return this.number;
    }

    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
        this.cachedBox = null;
        this.m_6596_();
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
        this.cachedBox = null;
        this.m_6596_();
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(GroupType groupType) {
        this.groupType = groupType;
        this.cachedBox = null;
        this.m_6596_();
    }

    protected void tickServer() {
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        this.support.setRedstoneState((GenericTileEntity)this, this.checkSensor() ? 15 : 0);
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public boolean checkSensor() {
        LogicFacing facing = LogicSupport.getFacing((BlockState)this.f_58857_.m_8055_(this.m_58899_()));
        Direction inputSide = facing.getInputSide();
        BlockPos newpos = this.m_58899_().m_121945_(inputSide);
        boolean newout = switch (this.sensorType) {
            default -> throw new IncompatibleClassChangeError();
            case SensorType.SENSOR_BLOCK -> this.checkBlockOrFluid(newpos, facing, inputSide, this::checkBlock);
            case SensorType.SENSOR_FLUID -> this.checkBlockOrFluid(newpos, facing, inputSide, this::checkFluid);
            case SensorType.SENSOR_GROWTHLEVEL -> this.checkGrowthLevel(newpos, facing, inputSide);
            case SensorType.SENSOR_ENTITIES -> this.checkEntities(newpos, facing, inputSide, Entity.class);
            case SensorType.SENSOR_PLAYERS -> this.checkEntities(newpos, facing, inputSide, Player.class);
            case SensorType.SENSOR_HOSTILE -> this.checkEntitiesHostile(newpos, facing, inputSide);
            case SensorType.SENSOR_PASSIVE -> this.checkEntitiesPassive(newpos, facing, inputSide);
            case SensorType.SENSOR_ITEMS -> this.checkEntityItems(newpos, facing, inputSide);
        };
        return newout;
    }

    private boolean checkBlockOrFluid(BlockPos newpos, LogicFacing facing, Direction dir, Function<BlockPos, Boolean> blockChecker) {
        int blockCount = this.areaType.getBlockCount();
        if (blockCount > 0) {
            Boolean x = this.checkBlockOrFluidRow(newpos, dir, blockChecker, blockCount);
            if (x != null) {
                return x;
            }
        } else if (blockCount < 0) {
            Direction downSide = facing.getSide();
            Direction inputSide = facing.getInputSide();
            Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
            Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
            Boolean x = this.checkBlockOrFluidRow(newpos, dir, blockChecker, blockCount = -blockCount);
            if (x != null) {
                return x;
            }
            for (int i = 1; i <= (blockCount - 1) / 2; ++i) {
                BlockPos p = newpos.m_5484_(leftSide, i);
                x = this.checkBlockOrFluidRow(p, dir, blockChecker, blockCount);
                if (x != null) {
                    return x;
                }
                p = newpos.m_5484_(rightSide, i);
                x = this.checkBlockOrFluidRow(p, dir, blockChecker, blockCount);
                if (x == null) continue;
                return x;
            }
        }
        return this.groupType == GroupType.GROUP_ALL;
    }

    private Boolean checkBlockOrFluidRow(BlockPos newpos, Direction dir, Function<BlockPos, Boolean> blockChecker, int count) {
        for (int i = 0; i < count; ++i) {
            boolean result = blockChecker.apply(newpos);
            if (result && this.groupType == GroupType.GROUP_ONE) {
                return true;
            }
            if (!result && this.groupType == GroupType.GROUP_ALL) {
                return false;
            }
            newpos = newpos.m_121945_(dir);
        }
        return null;
    }

    private boolean checkBlock(BlockPos newpos) {
        BlockState state = this.f_58857_.m_8055_(newpos);
        ItemStack matcher = this.items.getStackInSlot(0);
        if (matcher.m_41619_()) {
            return state.m_60815_();
        }
        ItemStack stack = state.m_60734_().m_7397_((BlockGetter)this.f_58857_, newpos, state);
        if (!stack.m_41619_()) {
            return matcher.m_41720_() == stack.m_41720_();
        }
        return matcher.m_41720_() == state.m_60734_().m_5456_();
    }

    private boolean checkFluid(BlockPos newpos) {
        BlockState state = this.f_58857_.m_8055_(newpos);
        ItemStack matcher = this.items.getStackInSlot(0);
        Block block = state.m_60734_();
        if (matcher.m_41619_()) {
            if (block instanceof LiquidBlock || block instanceof IFluidBlock) {
                return !this.f_58857_.m_8055_(newpos).m_60795_();
            }
            return false;
        }
        ItemStack stack = block.m_7397_((BlockGetter)this.f_58857_, newpos, state);
        Item matcherItem = matcher.m_41720_();
        FluidStack matcherFluidStack = null;
        if (matcherItem instanceof BucketItem) {
            matcherFluidStack = new FluidBucketWrapper(matcher).getFluid();
            return this.checkFluid(block, matcherFluidStack, state, newpos);
        }
        return false;
    }

    private boolean checkFluid(Block block, FluidStack matcherFluidStack, BlockState state, BlockPos newpos) {
        if (matcherFluidStack == null) {
            return this.f_58857_.m_8055_(newpos).m_60795_();
        }
        Fluid matcherFluid = matcherFluidStack.getFluid();
        if (matcherFluid == null) {
            return false;
        }
        Block matcherFluidBlock = matcherFluid.m_76145_().m_76188_().m_60734_();
        return matcherFluidBlock == block;
    }

    private boolean checkGrowthLevel(BlockPos newpos, LogicFacing facing, Direction dir) {
        int blockCount = this.areaType.getBlockCount();
        if (blockCount > 0) {
            Boolean x = this.checkGrowthLevelRow(newpos, dir, blockCount);
            if (x != null) {
                return x;
            }
        } else if (blockCount < 0) {
            Direction downSide = facing.getSide();
            Direction inputSide = facing.getInputSide();
            Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
            Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
            Boolean x = this.checkGrowthLevelRow(newpos, dir, blockCount = -blockCount);
            if (x != null) {
                return x;
            }
            for (int i = 1; i <= (blockCount - 1) / 2; ++i) {
                BlockPos p = newpos.m_5484_(leftSide, i);
                x = this.checkGrowthLevelRow(p, dir, blockCount);
                if (x != null) {
                    return x;
                }
                p = newpos.m_5484_(rightSide, i);
                x = this.checkGrowthLevelRow(p, dir, blockCount);
                if (x == null) continue;
                return x;
            }
        }
        return this.groupType == GroupType.GROUP_ALL;
    }

    private Boolean checkGrowthLevelRow(BlockPos newpos, Direction dir, int blockCount) {
        for (int i = 0; i < blockCount; ++i) {
            boolean result = this.checkGrowthLevel(newpos);
            if (result && this.groupType == GroupType.GROUP_ONE) {
                return true;
            }
            if (!result && this.groupType == GroupType.GROUP_ALL) {
                return false;
            }
            newpos = newpos.m_121945_(dir);
        }
        return null;
    }

    private boolean checkGrowthLevel(BlockPos newpos) {
        BlockState state = this.f_58857_.m_8055_(newpos);
        int pct = 0;
        for (Property property : state.m_61147_()) {
            if (!"age".equals(property.m_61708_())) continue;
            if (property.m_61709_() != Integer.class) break;
            Property integerProperty = property;
            int age = (Integer)state.m_61143_(integerProperty);
            int maxAge = (Integer)Collections.max(integerProperty.m_6908_());
            pct = age * 100 / maxAge;
            break;
        }
        return pct >= this.number;
    }

    public void invalidateCache() {
        this.cachedBox = null;
    }

    private AABB getCachedBox(BlockPos pos1, LogicFacing facing, Direction dir) {
        if (this.cachedBox == null) {
            int n = this.areaType.getBlockCount();
            if (n > 0) {
                this.cachedBox = new AABB(pos1);
                if (n > 1) {
                    BlockPos pos2 = pos1.m_5484_(dir, n - 1);
                    this.cachedBox = this.cachedBox.m_82367_(new AABB(pos2));
                }
                this.cachedBox = this.cachedBox.m_82363_(0.1, 0.1, 0.1);
            } else {
                BlockPos pos2;
                n = -n;
                this.cachedBox = new AABB(pos1);
                Direction downSide = facing.getSide();
                Direction inputSide = facing.getInputSide();
                Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
                Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
                if (n > 1) {
                    pos2 = pos1.m_5484_(dir, n - 1);
                    this.cachedBox = this.cachedBox.m_82367_(new AABB(pos2));
                }
                pos2 = pos1.m_5484_(leftSide, (n - 1) / 2);
                this.cachedBox = this.cachedBox.m_82367_(new AABB(pos2));
                pos2 = pos1.m_5484_(rightSide, (n - 1) / 2);
                this.cachedBox = this.cachedBox.m_82367_(new AABB(pos2));
            }
        }
        return this.cachedBox;
    }

    private boolean checkEntityItems(BlockPos pos1, LogicFacing facing, Direction dir) {
        List entities = this.f_58857_.m_45976_(ItemEntity.class, this.getCachedBox(pos1, facing, dir));
        int cnt = 0;
        for (Entity entity : entities) {
            ItemEntity itemEntity;
            if (!(entity instanceof ItemEntity) || (cnt += (itemEntity = (ItemEntity)entity).m_32055_().m_41613_()) < this.number) continue;
            return true;
        }
        return false;
    }

    private boolean checkEntities(BlockPos pos1, LogicFacing facing, Direction dir, Class<? extends Entity> clazz) {
        List entities = this.f_58857_.m_45976_(clazz, this.getCachedBox(pos1, facing, dir));
        return entities.size() >= this.number;
    }

    private boolean checkEntitiesHostile(BlockPos pos1, LogicFacing facing, Direction dir) {
        List entities = this.f_58857_.m_45976_(PathfinderMob.class, this.getCachedBox(pos1, facing, dir));
        int cnt = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof Enemy) || ++cnt < this.number) continue;
            return true;
        }
        return false;
    }

    private boolean checkEntitiesPassive(BlockPos pos1, LogicFacing facing, Direction dir) {
        List entities = this.f_58857_.m_45976_(PathfinderMob.class, this.getCachedBox(pos1, facing, dir));
        int cnt = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof Mob) || entity instanceof Enemy || ++cnt < this.number) continue;
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.support.setPowerOutput(tagCompound.m_128471_("rs") ? 15 : 0);
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.number = info.m_128451_("number");
        this.sensorType = SensorType.values()[info.m_128445_("sensor")];
        this.areaType = AreaType.values()[info.m_128445_("area")];
        this.groupType = GroupType.values()[info.m_128445_("group")];
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128379_("rs", this.support.getPowerOutput() > 0);
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("number", this.number);
        info.m_128344_("sensor", (byte)this.sensorType.ordinal());
        info.m_128344_("area", (byte)this.areaType.ordinal());
        info.m_128344_("group", (byte)this.groupType.ordinal());
    }

    public void rotateBlock(Rotation axis) {
        this.invalidateCache();
    }
}

