/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.spawner.SpawnerConfiguration;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.spawner.blocks.MatterBeamerTileEntity;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class SpawnerTileEntity
extends TickingTileEntity {
    public float matterReceived0 = -1.0f;
    public float matterReceived1 = -1.0f;
    public float matterReceived2 = -1.0f;
    public static final int SLOT_SYRINGE = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).box(SlotDefinition.specific((Item[])new Item[]{SpawnerModule.SYRINGE.get()}).in().out(), 0, 22, 8, 1, 18, 1, 18).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid(GenericItemHandler.match(SpawnerModule.SYRINGE)).onUpdate((slot, stack) -> {
        this.checkSyringe = true;
        this.prevMobId = this.mobId;
    }).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)SpawnerConfiguration.SPAWNER_MAXENERGY, (long)SpawnerConfiguration.SPAWNER_RECEIVEPERTICK);
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Spawner").containerSupplier(DefaultContainerProvider.container(SpawnerModule.CONTAINER_SPAWNER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    private final LazyOptional<IMachineInformation> infoHandler = LazyOptional.of(this::createMachineInfo);
    @Cap(type=CapType.MODULE)
    private final IModuleSupport moduleSupportHandler = new DefaultModuleSupport(0){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.m_41720_() == SpawnerModule.SYRINGE.get();
        }
    };
    private final float[] matter = new float[]{0.0f, 0.0f, 0.0f};
    private boolean checkSyringe = true;
    private String prevMobId = null;
    private String mobId = "";
    private AABB entityCheckBox = null;
    public static final Key<Double> PARAM_MATTER0 = new Key("matter0", Type.DOUBLE);
    public static final Key<Double> PARAM_MATTER1 = new Key("matter1", Type.DOUBLE);
    public static final Key<Double> PARAM_MATTER2 = new Key("matter2", Type.DOUBLE);
    @ServerCommand
    public static final ResultCommand<?> CMD_GET_SPAWNERINFO = ResultCommand.create((String)"getSpawnerInfo", (te, player, params) -> TypedMap.builder().put(PARAM_MATTER0, (Object)te.matter[0]).put(PARAM_MATTER1, (Object)te.matter[1]).put(PARAM_MATTER2, (Object)te.matter[2]).build(), (te, player, params) -> {
        te.matterReceived0 = ((Double)params.get(PARAM_MATTER0)).floatValue();
        te.matterReceived1 = ((Double)params.get(PARAM_MATTER1)).floatValue();
        te.matterReceived2 = ((Double)params.get(PARAM_MATTER2)).floatValue();
    });

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(SpawnerTileEntity::new).topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsutility:todo")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));
    }

    public SpawnerTileEntity(BlockPos pos, BlockState state) {
        super(SpawnerModule.TYPE_SPAWNER.get(), pos, state);
    }

    private void testSyringe() {
        if (!this.checkSyringe) {
            return;
        }
        this.checkSyringe = false;
        this.mobId = null;
        ItemStack itemStack = this.items.getStackInSlot(0);
        if (itemStack.m_41619_()) {
            this.clearMatter();
            return;
        }
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound == null) {
            this.clearMatter();
            return;
        }
        this.mobId = tagCompound.m_128461_("mobId");
        if (this.mobId.isEmpty()) {
            this.clearMatter();
            return;
        }
        int level = tagCompound.m_128451_("level");
        if (level < (Integer)SpawnerConfiguration.maxMobInjections.get()) {
            this.clearMatter();
            return;
        }
        if (this.prevMobId != null && !this.prevMobId.equals(this.mobId)) {
            this.clearMatter();
        }
    }

    public GenericItemHandler getItems() {
        return this.items;
    }

    private void clearMatter() {
        if (this.matter[0] != 0.0f || this.matter[1] != 0.0f || this.matter[2] != 0.0f) {
            this.matter[2] = 0.0f;
            this.matter[1] = 0.0f;
            this.matter[0] = 0.0f;
            this.m_6596_();
        }
    }

    public boolean addMatter(ItemStack stack, int m, float beamerInfusionFactor) {
        this.testSyringe();
        if (this.mobId == null || this.mobId.isEmpty()) {
            return false;
        }
        int materialType = 0;
        Float factor = null;
        SpawnerRecipes.MobData mobData = this.getMobData();
        if (mobData == null) {
            return false;
        }
        for (int i = 0; i < 3 && (factor = mobData.getItem(i).match(stack)) == null; ++i) {
            ++materialType;
        }
        if (factor == null) {
            return false;
        }
        float mm = this.matter[materialType];
        if ((mm += (float)m * factor.floatValue() * 3.0f / (3.0f - beamerInfusionFactor)) > (float)SpawnerConfiguration.maxMatterStorage) {
            mm = SpawnerConfiguration.maxMatterStorage;
        }
        this.matter[materialType] = mm;
        this.m_6596_();
        return true;
    }

    @Nullable
    private SpawnerRecipes.MobData getMobData() {
        SpawnerRecipes.MobData mobData = SpawnerRecipes.getMobData(this.f_58857_, this.mobId);
        if (mobData == null) {
            Logging.logError((String)("The mob spawn amounts list for mob " + this.mobId + " is missing!"));
        }
        return mobData;
    }

    public float[] getMatter() {
        return this.matter;
    }

    protected void tickServer() {
        this.testSyringe();
        if (this.mobId == null || this.mobId.isEmpty()) {
            return;
        }
        SpawnerRecipes.MobData mobData = this.getMobData();
        if (mobData == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (!(this.matter[i] < mobData.getItem(i).getAmount())) continue;
            return;
        }
        int rf = mobData.getSpawnRf();
        rf = (int)((float)rf * (2.0f - this.infusable.getInfusedFactor()) / 2.0f);
        if (this.energyStorage.getEnergyStored() < rf) {
            return;
        }
        this.energyStorage.consumeEnergy((long)rf);
        for (int i = 0; i < 3; ++i) {
            int n = i;
            this.matter[n] = this.matter[n] - mobData.getItem(i).getAmount();
        }
        this.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        Direction k = OrientationTools.getOrientation((BlockState)state);
        int sx = this.m_58899_().m_123341_();
        int sy = this.m_58899_().m_123342_();
        int sz = this.m_58899_().m_123343_();
        Vec3i dir = k.m_122436_();
        sx += dir.m_123341_();
        sy += dir.m_123342_();
        sz += dir.m_123343_();
        EntityType type = Tools.getEntity((ResourceLocation)new ResourceLocation(this.mobId));
        if (type == null) {
            Logging.logError((String)("Fail to spawn mob: " + this.mobId));
            return;
        }
        Entity entityLiving = type.m_20615_(this.f_58857_);
        if (entityLiving == null) {
            Logging.logError((String)("Fail to spawn mob: " + this.mobId));
            return;
        }
        entityLiving.getPersistentData().m_128379_("rftoolsutility:spawner", true);
        if (k == Direction.DOWN) {
            sy = (int)((float)sy - (entityLiving.m_20192_() - 1.0f));
        }
        entityLiving.m_7678_((double)sx + 0.5, (double)sy, (double)sz + 0.5, 0.0f, 0.0f);
        this.f_58857_.m_7967_(entityLiving);
    }

    public void useWrench(Player player) {
        BlockPos coord = RFToolsBase.instance.clientInfo.getSelectedTE();
        if (coord == null) {
            return;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(coord);
        double d = new Vec3((double)coord.m_123341_(), (double)coord.m_123342_(), (double)coord.m_123343_()).m_82554_(new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()));
        if (d > (double)SpawnerConfiguration.maxBeamDistance) {
            Logging.message((Player)player, (String)"Destination distance is too far!");
        } else if (tileEntity instanceof MatterBeamerTileEntity) {
            MatterBeamerTileEntity beamer = (MatterBeamerTileEntity)tileEntity;
            beamer.setDestination(this.m_58899_());
            Logging.message((Player)player, (String)"Destination set!");
        }
        RFToolsBase.instance.clientInfo.setSelectedTE(null);
        RFToolsBase.instance.clientInfo.setDestinationTE(null);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.matter[0] = info.m_128457_("matter0");
        this.matter[1] = info.m_128457_("matter1");
        this.matter[2] = info.m_128457_("matter2");
        this.mobId = info.m_128441_("mobId") ? info.m_128461_("mobId") : null;
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128350_("matter0", this.matter[0]);
        info.m_128350_("matter1", this.matter[1]);
        info.m_128350_("matter2", this.matter[2]);
        if (this.mobId != null && !this.mobId.isEmpty()) {
            info.m_128359_("mobId", this.mobId);
        }
    }

    public boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        if (world.f_46443_) {
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundTools.findSound((ResourceLocation)new ResourceLocation("minecraft", "block.note_block.pling")), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            this.useWrench(player);
        }
        return true;
    }

    @Nonnull
    private IMachineInformation createMachineInfo() {
        return new IMachineInformation(){
            private final String[] TAGS = new String[]{"matter1", "matter2", "matter3", "mob"};
            private final String[] TAG_DESCRIPTIONS = new String[]{"The amount of matter in the first slot", "The amount of matter in the second slot", "The amount of matter in the third slot", "The name of the mob being spawned"};

            public int getTagCount() {
                return this.TAGS.length;
            }

            public String getTagName(int index) {
                return this.TAGS[index];
            }

            public String getTagDescription(int index) {
                return this.TAG_DESCRIPTIONS[index];
            }

            public String getData(int index, long millis) {
                switch (index) {
                    case 0: {
                        return Float.toString(SpawnerTileEntity.this.matter[0]);
                    }
                    case 1: {
                        return Float.toString(SpawnerTileEntity.this.matter[1]);
                    }
                    case 2: {
                        return Float.toString(SpawnerTileEntity.this.matter[2]);
                    }
                    case 3: {
                        return SpawnerTileEntity.this.mobId;
                    }
                }
                return null;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY) {
            return this.infoHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

