/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.network;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.rftoolsutility.modules.teleporter.network.PacketAllReceiversReady;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public record PacketGetAllReceivers() implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsutility", "getallreceivers");

    public void write(FriendlyByteBuf buf) {
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketGetAllReceivers create(FriendlyByteBuf buf) {
        return new PacketGetAllReceivers();
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            TeleportDestinations destinations = TeleportDestinations.get(player.m_9236_());
            ArrayList<TeleportDestinationClientInfo> destinationList = new ArrayList<TeleportDestinationClientInfo>(destinations.getValidDestinations(player.m_20193_(), null));
            this.addDimensions(player.m_9236_(), destinationList);
            this.addRfToolsDimensions(player.m_20193_(), destinationList);
            PacketAllReceiversReady msg = new PacketAllReceiversReady(destinationList);
            RFToolsUtilityMessages.sendToPlayer(msg, player);
        }));
    }

    private void addDimensions(Level worldObj, List<TeleportDestinationClientInfo> destinationList) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerLevel world : server.m_129785_()) {
            ResourceKey id = world.m_46472_();
            TeleportDestination destination = new TeleportDestination(new BlockPos(0, 70, 0), (ResourceKey<Level>)id);
            destination.setName("Dimension: " + id.m_135782_().m_135815_());
            TeleportDestinationClientInfo teleportDestinationClientInfo = new TeleportDestinationClientInfo(destination);
            String dimName = id.m_135782_().m_135815_();
            teleportDestinationClientInfo.setDimensionName(dimName);
            destinationList.add(teleportDestinationClientInfo);
        }
    }

    private void addRfToolsDimensions(Level world, List<TeleportDestinationClientInfo> destinationList) {
    }
}

