/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester;

import appeng.api.networking.IGrid;
import appeng.menu.implementations.MenuTypeBuilder;
import com.almostreliable.merequester.platform.Platform;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.requester.abstraction.AbstractRequesterMenu;
import com.almostreliable.merequester.requester.abstraction.RequestTracker;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public final class RequesterMenu
extends AbstractRequesterMenu {
    public static final MenuType<RequesterMenu> TYPE = MenuTypeBuilder.create(RequesterMenu::new, RequesterBlockEntity.class).build("requester");
    @Nullable
    private RequestTracker requestTracker;

    private RequesterMenu(int id, Inventory playerInventory, RequesterBlockEntity host) {
        super(TYPE, id, playerInventory, host);
    }

    public void m_38946_() {
        if (this.isClientSide()) {
            return;
        }
        super.m_38946_();
        if (this.requestTracker == null) {
            this.sendFullUpdate(null);
        } else {
            this.sendPartialUpdate();
        }
    }

    protected ItemStack transferStackToMenu(ItemStack stack) {
        assert (this.requestTracker != null);
        int firstAvailable = this.requestTracker.getServer().firstAvailableIndex();
        if (firstAvailable != -1) {
            this.requestTracker.getServer().insertItem(firstAvailable, stack, false);
        }
        return stack;
    }

    @Override
    protected void sendFullUpdate(@Nullable IGrid grid) {
        Platform.sendClearData(this.getPlayer());
        this.requestTracker = this.createTracker((RequesterBlockEntity)this.getBlockEntity());
        this.syncRequestTrackerFull(this.requestTracker);
    }

    @Override
    protected void sendPartialUpdate() {
        assert (this.requestTracker != null);
        this.syncRequestTrackerPartial(this.requestTracker);
    }

    @Override
    @Nullable
    protected RequestTracker getRequestTracker(long id) {
        return this.requestTracker;
    }
}

