/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.compat;

import java.util.function.Predicate;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.xnet.apiimpl.items.ItemChannelSettings;
import mcjty.xnet.apiimpl.items.ItemConnectorSettings;
import mcjty.xnet.apiimpl.items.enums.StackMode;
import mcjty.xnet.setup.Config;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RFToolsSupport {
    public static boolean isStorageScanner(BlockEntity te) {
        return te instanceof IStorageScanner;
    }

    public static void tickStorageScanner(IControllerContext context, ItemConnectorSettings settings, BlockEntity te, ItemChannelSettings channelSettings, Level world) {
        int remaining;
        IStorageScanner scanner = (IStorageScanner)te;
        Predicate<ItemStack> extractMatcher = settings.getMatcher(context);
        Integer count = settings.getCount();
        int amount = 0;
        if (count != null && (amount = scanner.countItems(extractMatcher, true, count)) < count) {
            return;
        }
        int cnt = switch (settings.getStackMode()) {
            default -> throw new IncompatibleClassChangeError();
            case StackMode.SINGLE -> 1;
            case StackMode.STACK -> 64;
            case StackMode.COUNT -> settings.getExtractAmount();
        };
        ItemStack stack = scanner.requestItem(extractMatcher, true, cnt, true);
        if (stack.m_41619_()) {
            return;
        }
        int toextract = stack.m_41613_();
        if (count != null) {
            int canextract = amount - count;
            if (canextract <= 0) {
                return;
            }
            if (canextract < toextract) {
                toextract = canextract;
                stack.m_41764_(toextract);
            }
        }
        if (context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue()) && (remaining = channelSettings.insertStack(context, stack, world, -1)) != toextract) {
            scanner.requestItem(extractMatcher, false, toextract - remaining, true);
        }
    }

    public static int countItems(BlockEntity te, Predicate<ItemStack> matcher, int count) {
        IStorageScanner scanner = (IStorageScanner)te;
        return scanner.countItems(matcher, true, Integer.valueOf(count));
    }

    public static int countItems(BlockEntity te, ItemStack stack, int count) {
        IStorageScanner scanner = (IStorageScanner)te;
        return scanner.countItems(stack, true, Integer.valueOf(count));
    }

    public static ItemStack insertItem(BlockEntity te, ItemStack stack, boolean simulate) {
        IStorageScanner scanner = (IStorageScanner)te;
        return scanner.insertItem(stack, simulate);
    }
}

