/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.tiles.IConnectorTile;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.modules.facade.MimicBlockSupport;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.setup.Config;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class ConnectorTileEntity
extends GenericTileEntity
implements IFacadeSupport,
IConnectorTile {
    private final MimicBlockSupport mimicBlockSupport = new MimicBlockSupport();
    private int energy = 0;
    private int[] inputFromSide = new int[]{0, 0, 0, 0, 0, 0};
    private int pulseCounter;
    private final int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    private byte enabled = (byte)63;
    private final LazyOptional<SidedHandler>[] sidedStorages;
    private final Block[] cachedNeighbours = new Block[OrientationTools.DIRECTION_VALUES.length];
    @GuiValue
    private String name = "";
    @Cap(type=CapType.CONTAINER)
    private LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider(I18nConstants.BLOCK_CONNECTOR.i18n(new Object[0])).containerSupplier(DefaultContainerProvider.empty(CableModule.CONTAINER_CONNECTOR, (GenericTileEntity)this)));
    public static final Key<Integer> PARAM_FACING = new Key("facing", Type.INTEGER);
    public static final Key<Boolean> PARAM_ENABLED = new Key("enabled", Type.BOOLEAN);
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_ENABLE = Command.create((String)"connector.enable", (te, playerEntity, params) -> {
        int f = (Integer)params.get(PARAM_FACING);
        boolean e = (Boolean)params.get(PARAM_ENABLED);
        te.setEnabled(OrientationTools.DIRECTION_VALUES[f], e);
    });
    @ServerCommand
    public static final ResultCommand<?> CMD_GET_NAME = ResultCommand.create((String)"xnet.connector.name", (te, player, params) -> TypedMap.builder().put(PARAM_NAME, (Object)te.getConnectorName()).build(), (te, player, params) -> te.setConnectorName((String)params.get(PARAM_NAME)));

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_.f_46443_ && this.getMimicBlock() != null) {
            this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
        }
    }

    public ConnectorTileEntity(BlockPos pos, BlockState state) {
        this(CableModule.TYPE_CONNECTOR.get(), pos, state);
    }

    protected ConnectorTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.sidedStorages = new LazyOptional[OrientationTools.DIRECTION_VALUES.length];
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            this.sidedStorages[direction.ordinal()] = LazyOptional.of(() -> this.createSidedHandler(direction));
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        if (this.f_58857_.f_46443_) {
            this.requestModelDataUpdate();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int getPowerOut(Direction side) {
        return this.powerOut[side.ordinal()];
    }

    public void setPowerOut(Direction side, int powerOut) {
        if (powerOut > 15) {
            powerOut = 15;
        }
        if (this.powerOut[side.ordinal()] == powerOut) {
            return;
        }
        this.powerOut[side.ordinal()] = powerOut;
        this.m_6596_();
        this.f_58857_.m_46586_(this.f_58858_.m_121945_(side), this.m_58900_().m_60734_(), this.f_58858_);
    }

    public void setEnabled(Direction direction, boolean e) {
        this.enabled = e ? (byte)(this.enabled | 1 << direction.ordinal()) : (byte)(this.enabled & ~(1 << direction.ordinal()));
        this.m_6596_();
        Block block = this.m_58900_().m_60734_();
        if (block instanceof GenericCableBlock) {
            this.f_58857_.m_7731_(this.f_58858_, ((GenericCableBlock)block).calculateState((LevelAccessor)this.f_58857_, this.f_58858_, this.m_58900_()), 3);
        }
    }

    public boolean isEnabled(Direction direction) {
        return (this.enabled & 1 << direction.ordinal()) != 0;
    }

    @Override
    public BlockState getMimicBlock() {
        return this.mimicBlockSupport.getMimicBlock();
    }

    public void setMimicBlock(BlockState mimicBlock) {
        this.mimicBlockSupport.setMimicBlock(mimicBlock);
        this.markDirtyClient();
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel == 0 && powered > 0) {
            ++this.pulseCounter;
        }
        super.setPowerInput(powered);
    }

    public int getPulseCounter() {
        return this.pulseCounter;
    }

    public void possiblyMarkNetworkDirty(@Nonnull BlockPos neighbor) {
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            if (!this.m_58899_().m_121945_(facing).equals((Object)neighbor)) continue;
            Block newblock = this.f_58857_.m_8055_(neighbor).m_60734_();
            if (newblock != this.cachedNeighbours[facing.ordinal()]) {
                this.cachedNeighbours[facing.ordinal()] = newblock;
                WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
                worldBlob.markNetworkDirty(worldBlob.getNetworkAt(this.m_58899_()));
            }
            return;
        }
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.energy = tagCompound.m_128451_("energy");
        this.inputFromSide = tagCompound.m_128465_("inputs");
        if (this.inputFromSide.length != 6) {
            this.inputFromSide = new int[]{0, 0, 0, 0, 0, 0};
        }
        this.mimicBlockSupport.readFromNBT(tagCompound);
        this.pulseCounter = tagCompound.m_128451_("pulse");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.m_128445_("p" + i);
        }
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.name = info.m_128461_("name");
        this.enabled = info.m_128441_("enabled") ? info.m_128445_("enabled") : (byte)63;
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128405_("energy", this.energy);
        tagCompound.m_128385_("inputs", this.inputFromSide);
        this.mimicBlockSupport.writeToNBT(tagCompound);
        tagCompound.m_128405_("pulse", this.pulseCounter);
        for (int i = 0; i < 6; ++i) {
            tagCompound.m_128344_("p" + i, (byte)this.powerOut[i]);
        }
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        this.mimicBlockSupport.writeToNBT(tagCompound);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.mimicBlockSupport.readFromNBT(tagCompound);
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128359_("name", this.name);
        info.m_128344_("enabled", this.enabled);
    }

    public void setConnectorName(String n) {
        this.name = n;
        this.m_6596_();
    }

    public String getConnectorName() {
        return this.name;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        if (this.energy != energy) {
            if (energy < 0) {
                energy = 0;
            }
            this.energy = energy;
            this.markDirtyQuick();
        }
    }

    public void setEnergyInputFrom(Direction from, int rate) {
        if (this.inputFromSide[from.ordinal()] != rate) {
            this.inputFromSide[from.ordinal()] = rate;
            this.markDirtyQuick();
        }
    }

    public int getMaxEnergy() {
        return (Integer)Config.maxRfConnector.get();
    }

    private int receiveEnergyInternal(Direction from, int maxReceive, boolean simulate) {
        if (from == null) {
            return 0;
        }
        int m = this.inputFromSide[from.ordinal()];
        if (m > 0) {
            int toreceive = Math.min(maxReceive, m);
            int newenergy = this.energy + toreceive;
            if (newenergy > this.getMaxEnergy()) {
                toreceive -= newenergy - this.getMaxEnergy();
                newenergy = this.getMaxEnergy();
            }
            if (!simulate && this.energy != newenergy) {
                this.energy = newenergy;
                this.inputFromSide[from.ordinal()] = 0;
                this.markDirtyQuick();
            }
            return toreceive;
        }
        return 0;
    }

    private int getEnergyStoredInternal() {
        return this.energy;
    }

    private int getMaxEnergyStoredInternal() {
        return this.getMaxEnergy();
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(GenericCableBlock.FACADEID, (Object)this.getMimicBlock()).build();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            if (side == null) {
                return LazyOptional.empty();
            }
            return this.sidedStorages[side.ordinal()].cast();
        }
        return super.getCapability(cap, side);
    }

    private SidedHandler createSidedHandler(Direction facing) {
        return new SidedHandler(facing);
    }

    class SidedHandler
    implements IEnergyStorage {
        private final Direction facing;

        public SidedHandler(Direction facing) {
            this.facing = facing;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return ConnectorTileEntity.this.receiveEnergyInternal(this.facing, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return ConnectorTileEntity.this.getEnergyStoredInternal();
        }

        public int getMaxEnergyStored() {
            return ConnectorTileEntity.this.getMaxEnergyStoredInternal();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

