/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.compat.mekanism;

import ad_astra_giselle_addon.common.entity.LivingHelper;
import java.util.function.Function;
import javax.annotation.Nullable;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AddonModuleHelper {
    public static <T extends ICustomModule<T>> IModule<T> findArmorEnabledModule(Entity entity, IModuleDataProvider<T> type) {
        for (ItemStack itemStack : entity.m_6168_()) {
            IModule module = IModuleHelper.INSTANCE.load(itemStack, type);
            if (module == null || !module.isEnabled()) continue;
            return module;
        }
        return null;
    }

    public static <T extends ICustomModule<T>> boolean useEnergy(LivingEntity living, IModuleDataProvider<T> type, @Nullable Function<T, FloatingLong> getEnergyUsing) {
        IModule<T> module = AddonModuleHelper.findArmorEnabledModule((Entity)living, type);
        if (module == null) {
            return false;
        }
        if (!LivingHelper.isPlayingMode(living)) {
            return true;
        }
        if (getEnergyUsing == null) {
            return true;
        }
        FloatingLong usingEnergy = getEnergyUsing.apply(module.getCustomInstance());
        if (module.canUseEnergy(living, usingEnergy)) {
            if (!living.m_9236_().m_5776_()) {
                module.useEnergy(living, usingEnergy);
            }
            return true;
        }
        return false;
    }

    private AddonModuleHelper() {
    }
}

