/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.api;

import java.io.Serializable;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Frequency
implements INBTSerializable<CompoundTag> {
    private UUID owner;
    private String ownerText;
    private int channel;

    public Frequency() {
        this(1);
    }

    public Frequency(int channel) {
        this(null, channel);
    }

    public Frequency(@Nullable Player player, int channel) {
        if (player == null) {
            this.owner = null;
            this.ownerText = "public";
        } else {
            this.owner = player.m_20148_();
            this.ownerText = player.m_7755_().getString();
        }
        this.channel = channel;
    }

    private Frequency(String ownerText, @Nullable UUID owner, int channel) {
        this.ownerText = ownerText;
        this.owner = owner;
        this.channel = channel;
    }

    public Frequency(CompoundTag tagCompound) {
        this.deserializeNBT(tagCompound);
    }

    public static Frequency readFromPacket(FriendlyByteBuf buf) {
        return new Frequency(buf.m_130277_(), buf.readBoolean() ? buf.m_130259_() : null, buf.m_130242_());
    }

    public Frequency set(Frequency frequency) {
        this.ownerText = frequency.ownerText;
        this.owner = frequency.owner;
        this.channel = frequency.channel;
        return this;
    }

    public Frequency copy() {
        return new Frequency(this.ownerText, this.owner, this.channel);
    }

    public Frequency setPublic() {
        this.owner = null;
        this.ownerText = "public";
        return this;
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public String getOwner() {
        return this.ownerText;
    }

    public Frequency setOwner(@NotNull Player player) {
        this.owner = player.m_20148_();
        this.ownerText = player.m_7755_().getString();
        return this;
    }

    public int getChannel() {
        return this.channel;
    }

    public Frequency setChannel(int channel) {
        this.channel = channel;
        return this;
    }

    public boolean hasOwner() {
        return !this.ownerText.equals("public") && this.owner != null;
    }

    public String toString() {
        return "owner=" + (Serializable)(this.hasOwner() ? this.owner : "public") + ",channel=" + this.channel;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency f = (Frequency)obj;
        if (f.hasOwner()) {
            return f.channel == this.channel && f.owner.equals(this.owner) && f.ownerText.equals(this.ownerText);
        }
        return f.channel == this.channel && f.ownerText.equals(this.ownerText);
    }

    public void writeToPacket(FriendlyByteBuf buf) {
        buf.m_130070_(this.ownerText);
        buf.writeBoolean(this.hasOwner());
        if (this.hasOwner()) {
            buf.m_130077_(this.owner);
        }
        buf.m_130130_(this.channel);
    }

    public boolean canAccess(@NotNull Player player) {
        if (!this.hasOwner()) {
            return true;
        }
        return this.getOwnerUUID().equals(player.m_20148_());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128359_("ownerText", this.ownerText);
        if (this.hasOwner()) {
            tagCompound.m_128362_("owner", this.owner);
        }
        tagCompound.m_128405_("channel", this.channel);
        return tagCompound;
    }

    public void deserializeNBT(CompoundTag tagCompound) {
        this.ownerText = tagCompound.m_128461_("ownerText");
        this.owner = !this.ownerText.equals("public") ? tagCompound.m_128342_("owner") : null;
        this.channel = tagCompound.m_128451_("channel");
    }
}

