/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.packet;

import edivad.dimstorage.DimStorage;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.network.packet.UpdateDimBase;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkHooks;

public class UpdateDimTank
extends UpdateDimBase {
    protected boolean autoEject;

    public UpdateDimTank(FriendlyByteBuf buf) {
        super(buf);
        this.autoEject = buf.readBoolean();
    }

    public UpdateDimTank(BlockEntityDimTank blockentity) {
        super(blockentity);
        this.autoEject = blockentity.autoEject;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        super.encode(buf);
        buf.writeBoolean(this.autoEject);
    }

    @Override
    public void customHandle(Level level, ServerPlayer player) {
        BlockEntity blockentity = level.m_7702_(this.pos);
        if (!(blockentity instanceof BlockEntityDimTank)) {
            DimStorage.LOGGER.error("Wrong type of blockentity (expected BlockEntityDimTank)!");
            return;
        }
        BlockEntityDimTank tank = (BlockEntityDimTank)blockentity;
        tank.setFrequency(this.freq);
        tank.locked = this.locked;
        tank.autoEject = this.autoEject;
        tank.m_6596_();
        level.m_7260_(this.pos, tank.m_58900_(), tank.m_58900_(), 3);
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)tank, buf -> buf.m_130064_(this.pos).writeBoolean(true));
    }
}

