/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import mcjty.deepresonance.compat.jei.laser.LaserRecipeCategory;
import mcjty.deepresonance.compat.jei.laser.LaserRecipeWrapper;
import mcjty.deepresonance.compat.jei.purifier.PurifierRecipeCategory;
import mcjty.deepresonance.compat.jei.purifier.PurifierRecipeWrapper;
import mcjty.deepresonance.compat.jei.smelter.SmelterRecipeCategory;
import mcjty.deepresonance.compat.jei.smelter.SmelterRecipeWrapper;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.data.InfusionBonusRegistry;
import mcjty.lib.varia.Tools;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class DeepResonanceJeiPlugin
implements IModPlugin {
    public static final RecipeType<LaserRecipeWrapper> LASER_RECIPE = RecipeType.create((String)"deepresonance", (String)"laser", LaserRecipeWrapper.class);
    public static final RecipeType<PurifierRecipeWrapper> PURIFIER_RECIPE = RecipeType.create((String)"deepresonance", (String)"purifier", PurifierRecipeWrapper.class);
    public static final RecipeType<SmelterRecipeWrapper> SMELTER_RECIPE = RecipeType.create((String)"deepresonance", (String)"smelter", SmelterRecipeWrapper.class);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("deepresonance", "jeiplugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachinesModule.LASER_BLOCK.get()), new RecipeType[]{LASER_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachinesModule.PURIFIER_BLOCK.get()), new RecipeType[]{PURIFIER_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MachinesModule.SMELTER_BLOCK.get()), new RecipeType[]{SMELTER_RECIPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new LaserRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new PurifierRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SmelterRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList recipes = new ArrayList();
        InfusionBonusRegistry.getInfusingBonusMap().forEach((id, bonus) -> recipes.add(new LaserRecipeWrapper(new ItemStack((ItemLike)Tools.getItem((ResourceLocation)id)))));
        registration.addRecipes(LASER_RECIPE, recipes);
        registration.addRecipes(PURIFIER_RECIPE, Collections.singletonList(new PurifierRecipeWrapper()));
        registration.addRecipes(SMELTER_RECIPE, Collections.singletonList(new SmelterRecipeWrapper()));
    }
}

