/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.data;

import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.tank.blocks.TankTileEntity;
import mcjty.deepresonance.modules.tank.data.DRTankNetwork;
import mcjty.deepresonance.modules.tank.data.TankBlob;
import mcjty.deepresonance.util.LiquidCrystalData;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DRTankHandler
implements IFluidHandler,
IFluidTank {
    private final TankTileEntity tank;

    public DRTankHandler(TankTileEntity tank) {
        this.tank = tank;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    private LiquidCrystalData getData() {
        Level level = this.tank.m_58904_();
        if (level == null || level.f_46443_) {
            return this.tank.getClientLiquidData();
        }
        TankBlob blob = DRTankNetwork.getNetwork(level).getBlob(this.tank.getMultiblockId());
        if (blob == null) {
            return LiquidCrystalData.EMPTY;
        }
        return blob.getData();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getData().getFluidStack();
    }

    public int getTankCapacity(int tankNr) {
        Level level = this.tank.m_58904_();
        if (level == null || level.f_46443_) {
            return 10000;
        }
        TankBlob blob = DRTankNetwork.getNetwork(level).getBlob(this.tank.getMultiblockId());
        if (blob != null) {
            return blob.getCapacity();
        }
        return 0;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        Level level = this.tank.m_58904_();
        if (level == null || level.f_46443_) {
            return 0;
        }
        TankBlob blob = DRTankNetwork.getNetwork(level).getBlob(this.tank.getMultiblockId());
        if (blob != null) {
            int filled = blob.fill(resource, action);
            if (filled > 0 && action.execute()) {
                this.onUpdate();
            }
            return filled;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        Level level = this.tank.m_58904_();
        if (level == null || level.f_46443_) {
            return FluidStack.EMPTY;
        }
        TankBlob blob = DRTankNetwork.getNetwork(level).getBlob(this.tank.getMultiblockId());
        if (blob != null) {
            FluidStack drained = blob.drain(resource, action);
            if (!drained.isEmpty() && action.execute()) {
                this.onUpdate();
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        Level level = this.tank.m_58904_();
        if (level == null || level.f_46443_) {
            return FluidStack.EMPTY;
        }
        TankBlob blob = DRTankNetwork.getNetwork(level).getBlob(this.tank.getMultiblockId());
        if (blob != null) {
            FluidStack drained = blob.drain(maxDrain, action);
            if (!drained.isEmpty() && action.execute()) {
                this.onUpdate();
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack getFluid() {
        Level level = this.tank.m_58904_();
        if (level == null || level.f_46443_) {
            return this.tank.getClientLiquidData().getFluidStack();
        }
        return this.getData().getFluidStack();
    }

    public int getFluidAmount() {
        Level level = this.tank.m_58904_();
        if (level == null || level.f_46443_) {
            return this.tank.getClientLiquidData().getFluidStack().getAmount();
        }
        return this.getData().getAmount();
    }

    public int getCapacity() {
        Level level = this.tank.m_58904_();
        if (level == null || level.f_46443_) {
            return 10000;
        }
        TankBlob blob = DRTankNetwork.getNetwork(level).getBlob(this.tank.getMultiblockId());
        if (blob != null) {
            return blob.getCapacity();
        }
        return 0;
    }

    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    public void onUpdate() {
    }
}

