/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import slimeknights.mantle.config.Config;

public class ExtraHeartRenderHandler {
    private static final ResourceLocation ICON_HEARTS = new ResourceLocation("mantle", "textures/gui/extra_hearts.png");
    private static final ResourceLocation ICON_VANILLA = Gui.f_279580_;
    private static final int HEART_VARIANTS = 12;
    private static final int HEART_SIZE = 9;
    private static final int HEART_OFFSET = 8;
    private static final int ROW_HEIGHT = 10;
    private static final int HARDCORE_OFFSET = 9;
    private static final int DAMAGE_OFFSET = 18;
    private static final int NORMAL_VARIANT = 0;
    private static final int POISON_VARIANT = 36;
    private static final int WITHER_VARIANT = 72;
    private static final int FREEZE_VARIANT = 108;
    private static final int ABSORPTION_VARIANT = 216;
    private static final int MAX_VARIANT = 180;
    private static final int NORMAL_CONTAINER = 216;
    private static final int ABSORPTION_CONTAINER = 234;
    private final Minecraft mc = Minecraft.m_91087_();
    private final int[] offsets = new int[20];
    private int lastHealth = 0;
    private int displayHealth = 0;
    private long healthBlinkTime = 0L;
    private long lastHealthTime = 0L;
    private final Random rand = new Random();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderHealthbar(RenderGuiOverlayEvent.Pre event) {
        ForgeGui gui;
        Config.HeartRenderer renderer;
        block30: {
            block29: {
                renderer = (Config.HeartRenderer)((Object)Config.HEART_RENDERER.get());
                if (renderer == Config.HeartRenderer.DISABLE || event.isCanceled() || event.getOverlay() != VanillaGuiOverlay.PLAYER_HEALTH.type()) {
                    return;
                }
                Gui gui2 = this.mc.f_91065_;
                if (!(gui2 instanceof ForgeGui)) break block29;
                gui = (ForgeGui)gui2;
                if (!this.mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) break block30;
            }
            return;
        }
        Entity renderViewEnity = this.mc.m_91288_();
        if (!(renderViewEnity instanceof Player)) {
            return;
        }
        Player player = (Player)renderViewEnity;
        gui.setupOverlayRenderState(true, false);
        this.mc.m_91307_().m_6180_("health");
        int tickCount = this.mc.f_91065_.m_93079_();
        int health = Mth.m_14167_((float)player.m_21223_());
        boolean highlight = this.healthBlinkTime > (long)tickCount && (this.healthBlinkTime - (long)tickCount) / 3L % 2L == 1L;
        long systemTime = Util.m_137550_();
        if (player.f_19802_ > 0) {
            if (health < this.lastHealth) {
                this.lastHealthTime = systemTime;
                this.healthBlinkTime = tickCount + 20;
            } else if (health > this.lastHealth) {
                this.lastHealthTime = systemTime;
                this.healthBlinkTime = tickCount + 10;
            }
        }
        if (systemTime - this.lastHealthTime > 1000L) {
            this.displayHealth = health;
            this.lastHealthTime = systemTime;
        }
        this.lastHealth = health;
        int displayHealth = this.displayHealth;
        this.rand.setSeed((long)tickCount * 312871L);
        Window window = this.mc.m_91268_();
        int left = window.m_85445_() / 2 - 91;
        int top = window.m_85446_() - gui.leftHeight;
        int maxHealth = Math.max(Mth.m_14165_((double)player.m_21133_(Attributes.f_22276_)), Math.max(displayHealth, health));
        int absorb = Mth.m_14167_((float)player.m_6103_());
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = tickCount % 25;
        }
        int container = 180;
        int heartOffset = 0;
        int absorpOffset = 216;
        if (player.m_21023_(MobEffects.f_19614_)) {
            heartOffset = 36;
        } else if (player.m_21023_(MobEffects.f_19615_)) {
            heartOffset = 72;
            absorpOffset = 72;
        } else if (player.m_146890_()) {
            heartOffset = 108;
        }
        assert (this.mc.f_91073_ != null);
        if (this.mc.f_91073_.m_6106_().m_5466_()) {
            heartOffset += 9;
            absorpOffset += 9;
            container += 9;
        }
        if (highlight) {
            container += 18;
        }
        boolean wiggle = health + absorb <= 4;
        int showHealth = Math.min(maxHealth, 20);
        int showHearts = (showHealth + 1) / 2;
        boolean compactAbsorption = showHearts < 10 && absorb <= 2 * (10 - showHearts);
        GuiGraphics graphics = event.getGuiGraphics();
        int absorptionOffset = 10;
        this.setOffsets(0, showHearts, wiggle, regen);
        if (renderer == Config.HeartRenderer.NO_MAX || maxHealth <= 20) {
            this.renderHeartRow(graphics, left, top, 0, 216, container, 0, showHealth / 2, showHealth % 2 == 1);
        } else {
            ++absorptionOffset;
            this.renderHearts(graphics, left, top - 2, container, maxHealth - 20, 0);
            this.renderHeartRow(graphics, left, top, 0, 216, container, 0, 10, false);
        }
        if (absorb > 0) {
            this.setOffsets(10, Math.min((absorb - 1) / 2, 10), wiggle, -1);
            boolean half = absorb < 20 && absorb % 2 == 1;
            int absorbHearts = absorb / 2;
            if (compactAbsorption) {
                this.renderHeartRow(graphics, left + 8 * showHearts, top, 10, 234, container, 0, absorbHearts, half);
            } else {
                this.renderHeartRow(graphics, left, top - absorptionOffset, 10, 234, container, 0, Math.min(absorbHearts, 10), half);
            }
        }
        if (highlight && displayHealth > health) {
            this.renderHeartsWithDamage(graphics, left, top, heartOffset, health, displayHealth);
        } else {
            this.renderHearts(graphics, left, top, heartOffset, health, 0);
        }
        if (compactAbsorption) {
            int absorbHearts = absorb / 2;
            this.renderHeartRow(graphics, left + showHearts * 8, top, 10, 0, absorpOffset, 0, absorbHearts, absorb % 2 == 1);
        } else {
            this.renderHearts(graphics, left, top - absorptionOffset, absorpOffset, absorb, 10);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_VANILLA);
        gui.leftHeight += 10;
        if (!compactAbsorption && absorb > 0) {
            gui.leftHeight += absorptionOffset;
        }
        event.setCanceled(true);
        RenderSystem.disableBlend();
        this.mc.m_91307_().m_7238_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Post(event.getWindow(), graphics, event.getPartialTick(), VanillaGuiOverlay.PLAYER_HEALTH.type()));
    }

    private static int colorOffset(int heartIndex) {
        return heartIndex % 12 * 2 * 9;
    }

    private void renderHearts(GuiGraphics graphics, int x, int y, int heartOffset, int count, int indexOffset) {
        int heartsTopColor = count % 20 / 2;
        int heartIndex = count / 20;
        if (count >= 20) {
            this.renderHeartRow(graphics, x, y, indexOffset, ExtraHeartRenderHandler.colorOffset(heartIndex - 1), heartOffset, heartsTopColor, 10, false);
        }
        this.renderHeartRow(graphics, x, y, indexOffset, ExtraHeartRenderHandler.colorOffset(heartIndex), heartOffset, 0, heartsTopColor, count % 2 == 1);
    }

    private void renderHeartsWithDamage(GuiGraphics graphics, int x, int y, int heartOffset, int current, int last) {
        boolean damageWrapped;
        int currentTopRow = current % 20;
        int currentRight = currentTopRow / 2;
        int lastTopRow = last % 20;
        int lastRight = lastTopRow / 2;
        int damageTaken = last - current;
        boolean bigDamage = damageTaken >= 20;
        boolean bl = damageWrapped = bigDamage || lastRight < currentRight;
        if (damageWrapped) {
            this.renderHeartRow(graphics, x, y, 0, ExtraHeartRenderHandler.colorOffset(last / 20 - 1), heartOffset + 18, bigDamage ? lastRight : currentRight, 10, false);
        } else {
            if (current >= 20) {
                this.renderHeartRow(graphics, x, y, 0, ExtraHeartRenderHandler.colorOffset(current / 20 - 1), heartOffset, lastRight, 10, false);
            }
            this.renderHeartRow(graphics, x, y, 0, ExtraHeartRenderHandler.colorOffset(last / 20), heartOffset + 18, currentRight, lastRight, lastTopRow % 2 == 1);
        }
        if (!bigDamage) {
            this.renderHeartRow(graphics, x, y, 0, ExtraHeartRenderHandler.colorOffset(current / 20), heartOffset, damageWrapped ? lastRight : 0, currentRight, currentTopRow % 2 == 1);
        }
        if (damageWrapped) {
            this.renderHeartRow(graphics, x, y, 0, ExtraHeartRenderHandler.colorOffset(last / 20), heartOffset + 18, 0, lastRight, lastTopRow % 2 == 1);
        }
    }

    private void renderHeartRow(GuiGraphics graphics, int x, int y, int indexOffset, int uOffset, int vOffset, int start, int end, boolean half) {
        for (int i = start; i < end; ++i) {
            graphics.m_280218_(ICON_HEARTS, x + 8 * i, y + this.offsets[i + indexOffset], uOffset, vOffset, 9, 9);
        }
        if (half) {
            graphics.m_280218_(ICON_HEARTS, x + 8 * end, y + this.offsets[end + indexOffset], uOffset + 9, vOffset, 9, 9);
        }
    }

    private void setOffsets(int indexOffset, int end, boolean wiggle, int regen) {
        for (int i = 0; i < end; ++i) {
            int offset = 0;
            if (wiggle) {
                offset = this.rand.nextInt(2);
            }
            if (i == regen) {
                offset -= 2;
            }
            this.offsets[i + indexOffset] = offset;
        }
    }
}

