/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.datamap;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class StateVariantStringBuilder {
    private final Block owner;
    private final Collection<Property<?>> properties;
    private final SortedMap<Property<?>, Comparable<?>> setStates = new TreeMap(Comparator.comparing(Property::m_61708_));
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    public StateVariantStringBuilder(Block owner) {
        this.owner = owner;
        this.properties = owner.m_49965_().m_61092_();
    }

    public <T extends Comparable<T>> StateVariantStringBuilder when(Property<T> prop, T value) {
        if (!this.properties.contains(prop)) {
            throw new IllegalArgumentException("Property " + prop + " is not valid for " + BuiltInRegistries.f_256975_.m_7981_((Object)this.owner));
        }
        T oldValue = this.setStates.putIfAbsent(prop, value);
        if (oldValue != null) {
            throw new IllegalArgumentException("Property " + prop + " has already been set");
        }
        return this;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (Map.Entry<Property<?>, Comparable<?>> entry : this.setStates.entrySet()) {
            if (ret.length() > 0) {
                ret.append(',');
            }
            ret.append(entry.getKey().m_61708_()).append('=').append(entry.getKey().m_6940_(entry.getValue()));
        }
        return ret.toString();
    }

    public static Predicate<BlockState> predicate(StateDefinition<Block, BlockState> container, String pVariant) {
        HashMap map = Maps.newHashMap();
        for (String propString : COMMA_SPLITTER.split((CharSequence)pVariant)) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)propString).iterator();
            if (!iterator.hasNext()) continue;
            String propName = (String)iterator.next();
            Property property = container.m_61081_(propName);
            if (property != null && iterator.hasNext()) {
                String valueString = (String)iterator.next();
                Comparable comparable = property.m_6215_(valueString).orElse(null);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + valueString + "' for blockstate property: '" + propName + "' " + property.m_6908_());
                }
                map.put(property, comparable);
                continue;
            }
            if (propName.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + propName + "'");
        }
        Block block = (Block)container.m_61091_();
        return state -> {
            if (state == null || !state.m_60713_(block)) {
                return false;
            }
            for (Map.Entry entry : map.entrySet()) {
                if (Objects.equals(state.m_61143_((Property)entry.getKey()), entry.getValue())) continue;
                return false;
            }
            return true;
        };
    }
}

