/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.transfer;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.network.packet.IThreadsafePacket;

public class FluidContainerTransferPacket
implements IThreadsafePacket {
    private final Set<Item> items;

    public FluidContainerTransferPacket(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        ArrayList<Item> builder = new ArrayList<Item>(size);
        for (int i = 0; i < size; ++i) {
            builder.add((Item)buffer.readRegistryIdUnsafe(ForgeRegistries.ITEMS));
        }
        this.items = Set.copyOf(builder);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.items.size());
        for (Item item : this.items) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)item);
        }
    }

    @Override
    public void handleThreadsafe(NetworkEvent.Context context) {
        FluidContainerTransferManager.INSTANCE.setContainerItems(this.items);
    }

    public FluidContainerTransferPacket(Set<Item> items) {
        this.items = items;
    }
}

