/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic.MysticStaff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class Bakuretsu {
    private int radius;
    private float posX;
    private float posY;
    private float posZ;
    public HashMap<Player, Vec3> knockback = new HashMap();
    private float damage;

    public Bakuretsu() {
    }

    public Bakuretsu(int r, float x, float y, float z, float damage) {
        this();
        this.radius = r;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.damage = damage;
    }

    public Bakuretsu(int r, BlockPos pos) {
        this();
        this.radius = r;
        this.posX = pos.m_123341_();
        this.posY = pos.m_123342_();
        this.posZ = pos.m_123343_();
    }

    public void explosionA(Level world, Player entity) {
        ArrayList<BlockPos> affected = new ArrayList<BlockPos>();
        List<Entity> lst = this.playerKnockback(world, entity);
        if (MTConfig.MYSTIC_STAFF_WORLD_DAMAGE) {
            for (float x = this.posX - (float)this.radius; x < this.posX + (float)this.radius + 1.0f; x += 1.0f) {
                for (float y = this.posY - (float)this.radius; y < this.posY + (float)this.radius + 1.0f; y += 1.0f) {
                    for (float z = this.posZ - (float)this.radius; z < this.posZ + (float)this.radius + 1.0f; z += 1.0f) {
                        BlockPos tmp;
                        Block b;
                        float cmp = (float)(this.radius * this.radius) - (this.posX - x) * (this.posX - x) - (this.posY - y) * (this.posY - y) - (this.posZ - z) * (this.posZ - z);
                        if (!(cmp > 0.0f) || EffectUtil.unchangableBlock(b = world.m_8055_(tmp = Utils.toBlockPos(x, y, z)).m_60734_(), Arrays.asList(Blocks.f_50627_, Blocks.f_50626_, Blocks.f_50080_, Blocks.f_50016_)) || !(b.getExplosionResistance(world.m_8055_(tmp), (BlockGetter)world, tmp, null) < 4000.0f)) continue;
                        affected.add(tmp);
                    }
                }
            }
            EffectUtil.tryFakeExplosion(affected, (Entity)entity, entity, "bakuretsu", false, lst);
        }
        Vec3 boom = new Vec3((double)this.posX, (double)this.posY, (double)this.posZ);
        for (Entity e : lst) {
            this.hurt(e, boom, entity);
        }
    }

    public List<Entity> playerKnockback(Level world, Player player) {
        AABB aabb = new AABB((double)(this.posX - (float)this.radius), (double)(this.posY - (float)this.radius), (double)(this.posZ - (float)this.radius), (double)(this.posX + (float)this.radius), (double)(this.posY + (float)this.radius), (double)(this.posZ + (float)this.radius));
        List entities = world.m_6249_((Entity)null, aabb, Entity::m_6084_);
        ArrayList<Entity> ret = new ArrayList<Entity>();
        Vec3 boom = new Vec3((double)this.posX, (double)this.posY, (double)this.posZ);
        for (Entity entity : entities) {
            double z;
            double y;
            double x;
            double cmp;
            if (entity.m_6128_() || entity instanceof MysticStaffMahoujinEntity || !((cmp = (double)(this.radius * this.radius) - ((double)this.posX - (x = entity.m_20185_())) * ((double)this.posX - x) - ((double)this.posY - (y = entity.m_20186_())) * ((double)this.posY - y) - ((double)this.posZ - (z = entity.m_20189_())) * ((double)this.posZ - z)) > 0.0)) continue;
            ret.add(entity);
        }
        return ret;
    }

    public void hurt(Entity entity, Vec3 boom, Player player) {
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        double cmp = (double)(this.radius * this.radius) - ((double)this.posX - x) * ((double)this.posX - x) - ((double)this.posY - y) * ((double)this.posY - y) - ((double)this.posZ - z) * ((double)this.posZ - z);
        float density = Bakuretsu.getBlockDensity(boom, entity);
        entity.m_6469_(player.m_269291_().m_269036_((Entity)player, null), this.damage * density);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).f_20889_ = 100;
        }
        Vec3 kb = new Vec3(x, y, z).m_82549_(new Vec3((double)(-this.posX), (double)(-this.posY), (double)(-this.posZ))).m_82541_().m_82490_(Math.sqrt(cmp) / 4.0);
        double motionX = entity.m_20184_().f_82479_;
        double motionY = entity.m_20184_().f_82480_;
        double motionZ = entity.m_20184_().f_82481_;
        entity.m_20334_(motionX += kb.f_82479_, motionY += kb.f_82480_, motionZ += kb.f_82481_);
        if (entity instanceof Player) {
            this.knockback.put((Player)entity, kb);
        }
    }

    public void explosionB(Level world, Player player) {
        Random rand = Utils.getRandom(world);
        world.m_6263_((Player)null, (double)this.posX, (double)this.posY, (double)this.posZ, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.2f) * 0.7f);
        for (float x = this.posX - (float)this.radius; x < this.posX + (float)this.radius + 1.0f; x += 1.0f) {
            for (float y = this.posY - (float)this.radius; y < this.posY + (float)this.radius + 1.0f; y += 1.0f) {
                for (float z = this.posZ - (float)this.radius; z < this.posZ + (float)this.radius + 1.0f; z += 1.0f) {
                    float cmp = (float)(this.radius * this.radius) - (this.posX - x) * (this.posX - x) - (this.posY - y) * (this.posY - y) - (this.posZ - z) * (this.posZ - z);
                    if (!(cmp > 0.0f) || !(cmp < 7.1f)) continue;
                    world.m_6493_((ParticleOptions)ParticleTypes.f_123812_, true, (double)x, (double)y, (double)z, 1.0, 0.0, 0.0);
                }
            }
        }
    }

    public static float getBlockDensity(Vec3 explosionVector, Entity entity) {
        AABB AABB2 = entity.m_20191_();
        double d0 = 1.0 / ((AABB2.f_82291_ - AABB2.f_82288_) * 2.0 + 1.0);
        double d1 = 1.0 / ((AABB2.f_82292_ - AABB2.f_82289_) * 2.0 + 1.0);
        double d2 = 1.0 / ((AABB2.f_82293_ - AABB2.f_82290_) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d5 = Mth.m_14139_((double)f, (double)AABB2.f_82288_, (double)AABB2.f_82291_);
                        double d6 = Mth.m_14139_((double)f1, (double)AABB2.f_82289_, (double)AABB2.f_82292_);
                        double d7 = Mth.m_14139_((double)f2, (double)AABB2.f_82290_, (double)AABB2.f_82293_);
                        Vec3 Vec32 = new Vec3(d5 + d3, d6, d7 + d4);
                        if (entity.m_9236_().m_45547_(new ClipContext(Vec32, explosionVector, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_6662_() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }
}

