/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.blocks.CartoucheBlock;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.packets.ClientboundCartoucheUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.AddressTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CartoucheEntity
extends BlockEntity
implements StructureGenEntity {
    public static final String ADDRESS_TABLE = "AddressTable";
    public static final String DIMENSION = "Dimension";
    public static final String SYMBOLS = "Symbols";
    public static final String ADDRESS = "Address";
    protected StructureGenEntity.Step generationStep = StructureGenEntity.Step.GENERATED;
    @Nullable
    private ResourceLocation addressTable;
    private ResourceLocation dimension;
    private ResourceLocation symbols;
    private Address address = new Address();

    public CartoucheEntity(BlockEntityType<?> cartouche, BlockPos pos, BlockState state) {
        super(cartouche, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.generationStep == StructureGenEntity.Step.READY) {
            this.generate();
        }
        if (this.dimension != null && this.address.isEmpty()) {
            this.setAddressFromDimension();
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("generation_step", 1)) {
            this.generationStep = StructureGenEntity.Step.fromByte(tag.m_128445_("generation_step"));
        }
        if (tag.m_128441_(ADDRESS_TABLE)) {
            this.addressTable = new ResourceLocation(tag.m_128461_(ADDRESS_TABLE));
        }
        if (tag.m_128441_(SYMBOLS)) {
            this.symbols = new ResourceLocation(tag.m_128461_(SYMBOLS));
        }
        if (tag.m_128441_(ADDRESS)) {
            this.address.fromArray(tag.m_128465_(ADDRESS));
        } else if (tag.m_128441_(DIMENSION)) {
            this.dimension = new ResourceLocation(tag.m_128461_(DIMENSION));
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        if (this.generationStep != StructureGenEntity.Step.GENERATED) {
            tag.m_128344_("generation_step", this.generationStep.byteValue());
        }
        if (this.addressTable != null) {
            tag.m_128359_(ADDRESS_TABLE, this.addressTable.toString());
        }
        if (this.symbols != null) {
            tag.m_128359_(SYMBOLS, this.symbols.toString());
        }
        if (!this.address.isFromDimension()) {
            tag.m_128385_(ADDRESS, this.address.toArray());
        } else if (this.dimension != null) {
            tag.m_128359_(DIMENSION, this.dimension.toString());
        }
        super.m_183515_(tag);
    }

    public void setDimension(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    public void setSymbols(ResourceLocation symbols) {
        this.symbols = symbols;
    }

    public ResourceLocation getSymbols() {
        return this.symbols;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    public ResourceLocation getAddressTable() {
        return this.addressTable;
    }

    public void setAddressFromAddressTable() {
        AddressTable addressTable = AddressTable.getAddressTable(this.f_58857_, this.addressTable);
        Address address = AddressTable.randomAddress(this.f_58857_.m_7654_(), addressTable);
        if (address != null) {
            this.address = address;
            if (address.isFromDimension()) {
                this.dimension = address.getDimension().m_135782_();
            }
        }
        this.addressTable = null;
        this.m_6596_();
    }

    public void setAddressFromDimension() {
        this.address.fromDimension(this.f_58857_.m_7654_(), Conversion.locationToDimension(this.dimension));
    }

    public void setSymbolsFromLevel(Level level) {
        if (level.m_5776_()) {
            return;
        }
        this.setSymbols(Universe.get(level).getSymbols((ResourceKey<Level>)level.m_46472_()).m_135782_());
    }

    public void setDimensionFromLevel(Level level) {
        if (level.m_5776_()) {
            return;
        }
        this.setDimension(level.m_46472_().m_135782_());
    }

    protected void updateClient() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundCartoucheUpdatePacket(this.f_58858_, this.symbols == null ? StargateJourney.EMPTY_LOCATION : this.symbols, this.addressTable == null ? this.address.toArray() : new int[]{}));
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.m_58899_().m_123341_() - 1), (double)this.m_58899_().m_123342_(), (double)(this.m_58899_().m_123343_() - 1), (double)(this.m_58899_().m_123341_() + 2), (double)(this.m_58899_().m_123342_() + 2), (double)(this.m_58899_().m_123343_() + 2));
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (state.m_61143_(CartoucheBlock.HALF) == DoubleBlockHalf.LOWER) {
            this.updateClient();
        }
    }

    @Override
    public void generateInStructure(WorldGenLevel level, RandomSource randomSource) {
        if (this.generationStep == StructureGenEntity.Step.SETUP) {
            this.generationStep = StructureGenEntity.Step.READY;
        }
    }

    public void generate() {
        if (this.addressTable != null) {
            this.setAddressFromAddressTable();
        }
        if (this.symbols == null) {
            this.setSymbolsFromLevel(this.f_58857_);
        }
        this.generationStep = StructureGenEntity.Step.GENERATED;
    }

    public static class RedSandstone
    extends CartoucheEntity {
        public RedSandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.RED_SANDSTONE_CARTOUCHE.get(), pos, state);
        }
    }

    public static class Sandstone
    extends CartoucheEntity {
        public Sandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.SANDSTONE_CARTOUCHE.get(), pos, state);
        }
    }

    public static class Stone
    extends CartoucheEntity {
        public Stone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.STONE_CARTOUCHE.get(), pos, state);
        }
    }
}

