/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.dhd;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.dhd.CrystalDHDEntity;
import net.povstalec.sgjourney.common.config.CommonDHDConfig;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.items.energy_cores.FusionCoreItem;

public class PegasusDHDEntity
extends CrystalDHDEntity {
    public PegasusDHDEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.PEGASUS_DHD.get(), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        PegasusDHDEntity.addTransferCrystals(this.itemHandler);
    }

    @Override
    protected long buttonPressEnergyCost() {
        return (Long)CommonDHDConfig.pegasus_dhd_button_press_energy_cost.get();
    }

    @Override
    protected long capacity() {
        return (Long)CommonDHDConfig.pegasus_dhd_energy_buffer_capacity.get();
    }

    @Override
    protected long maxReceive() {
        return (Long)CommonDHDConfig.pegasus_dhd_max_energy_receive.get();
    }

    @Override
    public long maxEnergyDeplete() {
        return this.maxEnergyTransfer < 0 ? (Long)CommonDHDConfig.pegasus_dhd_max_energy_extract.get() : (long)this.maxEnergyTransfer;
    }

    @Override
    protected SoundEvent getEnterSound() {
        return (SoundEvent)SoundInit.PEGASUS_DHD_ENTER.get();
    }

    @Override
    protected SoundEvent getPressSound() {
        return (SoundEvent)SoundInit.PEGASUS_DHD_PRESS.get();
    }

    public static void addTransferCrystals(ItemStackHandler itemHandler) {
        int slots = itemHandler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!stack.m_150930_((Item)ItemInit.ADVANCED_ENERGY_CRYSTAL.get()) || !stack.m_41782_() || !stack.m_41783_().m_128461_("CrystalMode").equals("ENERGY_TRANSFER")) continue;
            itemHandler.setStackInSlot(i, new ItemStack((ItemLike)ItemInit.TRANSFER_CRYSTAL.get()));
            StargateJourney.LOGGER.info("Replaced Transfer Crystal");
        }
    }

    @Override
    protected void generateEnergyCore() {
        this.energyItemHandler.setStackInSlot(0, FusionCoreItem.randomFusionCore((Integer)CommonTechConfig.fusion_core_fuel_capacity.get() / 2, (Integer)CommonTechConfig.fusion_core_fuel_capacity.get()));
    }

    @Override
    protected void generateCrystals() {
        this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)ItemInit.LARGE_CONTROL_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)ItemInit.ADVANCED_ENERGY_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)ItemInit.ADVANCED_COMMUNICATION_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)ItemInit.ADVANCED_ENERGY_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(6, new ItemStack((ItemLike)ItemInit.ADVANCED_COMMUNICATION_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(7, new ItemStack((ItemLike)ItemInit.ADVANCED_TRANSFER_CRYSTAL.get()));
    }
}

