/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.tech;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.povstalec.sgjourney.common.block_entities.tech.TransceiverEntity;
import net.povstalec.sgjourney.common.blockstates.Receiving;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.menu.TransceiverMenu;
import net.povstalec.sgjourney.common.misc.VoxelShapeProvider;
import org.joml.Vector3d;

public class TransceiverBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Receiving> RECEIVING = EnumProperty.m_61587_((String)"receiving", Receiving.class);
    public static final BooleanProperty TRANSMITTING = BooleanProperty.m_61465_((String)"transmitting");
    private static final int TICKS_ACTIVE = 20;
    private static final ArrayList<Tuple<Vector3d, Vector3d>> MIN_MAX = new ArrayList<Tuple>(Arrays.asList(new Tuple((Object)new Vector3d(2.0, 0.0, 3.0), (Object)new Vector3d(14.0, 4.0, 16.0))));
    private static final VoxelShape SHAPE_NORTH = VoxelShapeProvider.getDirectionalShapes(MIN_MAX, Direction.NORTH);
    private static final VoxelShape SHAPE_EAST = VoxelShapeProvider.getDirectionalShapes(MIN_MAX, Direction.EAST);
    private static final VoxelShape SHAPE_SOUTH = VoxelShapeProvider.getDirectionalShapes(MIN_MAX, Direction.SOUTH);
    private static final VoxelShape SHAPE_WEST = VoxelShapeProvider.getDirectionalShapes(MIN_MAX, Direction.WEST);

    public TransceiverBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(RECEIVING, (Comparable)((Object)Receiving.FALSE))).m_61124_((Property)TRANSMITTING, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TransceiverEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{RECEIVING}).m_61104_(new Property[]{TRANSMITTING});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55948_().m_56528_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54842_().m_56528_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.m_5776_()) {
            final BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TransceiverEntity) {
                MenuProvider containerProvider = new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"screen.sgjourney.transceiver");
                    }

                    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new TransceiverMenu(windowId, playerInventory, blockEntity);
                    }
                };
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)blockEntity.m_58899_());
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        level.m_7731_(pos, (BlockState)state.m_61124_(RECEIVING, (Comparable)((Object)Receiving.FALSE)), 3);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        Receiving receiving = (Receiving)((Object)state.m_61143_(RECEIVING));
        if (receiving != null) {
            return receiving.getRedstonePower();
        }
        return 0;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bool) {
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            return;
        }
        if (level.m_276867_(pos) && (blockEntity = level.m_7702_(pos)) instanceof TransceiverEntity) {
            TransceiverEntity transceiver = (TransceiverEntity)blockEntity;
            transceiver.sendTransmission();
        }
        super.m_6861_(state, level, pos, block, pos2, bool);
    }

    public void receiveTransmission(BlockState state, Level level, BlockPos pos, boolean codeIsCorrect) {
        if (codeIsCorrect) {
            level.m_7731_(pos, (BlockState)state.m_61124_(RECEIVING, (Comparable)((Object)Receiving.RECEIVING_CORRECT)), 3);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_(RECEIVING, (Comparable)((Object)Receiving.RECEIVING_INCORRECT)), 3);
        }
        level.m_186460_(pos, (Block)this, 20);
    }

    public void stopTransmitting(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)TRANSMITTING, (Comparable)Boolean.valueOf(false)), 2);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"block.sgjourney.transceiver.description").m_130940_(ChatFormatting.GRAY));
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> typeA, BlockEntityType<E> typeB, BlockEntityTicker<? super E> ticker) {
        return typeB == typeA ? ticker : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TransceiverBlock.createTickerHelper(type, (BlockEntityType)BlockEntityInit.TRANSCEIVER.get(), TransceiverEntity::tick);
    }
}

