/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blockstates;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.povstalec.sgjourney.common.misc.ComponentHelper;

public enum InterfaceMode implements StringRepresentable
{
    OFF("off", (Component)Component.m_237115_((String)"block.sgjourney.interface.mode.off").m_130940_(ChatFormatting.DARK_GRAY), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.off.usage")}),
    RING_SEGMENT("ring_segment", (Component)Component.m_237115_((String)"block.sgjourney.interface.mode.ring_segment").m_130940_(ChatFormatting.GREEN), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.ring_segment.usage"), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.ring_segment.usage_1").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.ring_segment.usage_2").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.ring_segment.usage_3").m_130940_(ChatFormatting.YELLOW)}),
    RING_ROTATION("ring_rotation", (Component)Component.m_237115_((String)"block.sgjourney.interface.mode.ring_rotation").m_130940_(ChatFormatting.DARK_GREEN), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.ring_rotation.usage"), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.ring_rotation.usage_1").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.ring_rotation.usage_2").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.ring_rotation.usage_3").m_130940_(ChatFormatting.YELLOW)}),
    CHEVRONS_ACTIVE("chevrons_active", (Component)Component.m_237115_((String)"block.sgjourney.interface.mode.chevrons_active").m_130940_(ChatFormatting.RED), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.chevrons_active.usage"), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.chevrons_active.usage_1").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.chevrons_active.usage_2").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.chevrons_active.usage_3").m_130940_(ChatFormatting.YELLOW)}),
    WORMHOLE_ACTIVE("wormhole_active", (Component)Component.m_237115_((String)"block.sgjourney.interface.mode.wormhole_active").m_130940_(ChatFormatting.AQUA), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.wormhole_active.usage"), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.wormhole_active.usage_1").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.wormhole_active.usage_2").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.wormhole_active.usage_3").m_130940_(ChatFormatting.YELLOW)}),
    IRIS("iris", (Component)Component.m_237115_((String)"block.sgjourney.interface.mode.iris").m_130940_(ChatFormatting.YELLOW), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.iris.usage.output"), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.iris.usage.output_1").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.iris.usage.output_2").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.iris.usage.output_3").m_130940_(ChatFormatting.YELLOW), ComponentHelper.usage("tooltip.sgjourney.interface.mode.iris.usage.input"), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.iris.usage.input_1").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"tooltip.sgjourney.interface.mode.iris.usage.input_2").m_130940_(ChatFormatting.YELLOW)}),
    SHIELDING("shielding", (Component)Component.m_237115_((String)"block.sgjourney.interface.mode.shielding").m_130940_(ChatFormatting.BLUE), new Component[]{ComponentHelper.usage("tooltip.sgjourney.interface.mode.shielding.usage")});

    private final String id;
    private final Component name;
    private final Component[] usage;

    private InterfaceMode(String id, Component name, Component ... usage) {
        this.id = id;
        this.name = name;
        this.usage = usage;
    }

    public String m_7912_() {
        return this.id;
    }

    public Component getName() {
        return this.name;
    }

    public Component[] getUsage() {
        return this.usage;
    }

    public InterfaceMode next(boolean isAdvanced) {
        return switch (this) {
            case OFF -> RING_SEGMENT;
            case RING_SEGMENT -> RING_ROTATION;
            case RING_ROTATION -> CHEVRONS_ACTIVE;
            case CHEVRONS_ACTIVE -> WORMHOLE_ACTIVE;
            case WORMHOLE_ACTIVE -> IRIS;
            case IRIS -> {
                if (isAdvanced) {
                    yield SHIELDING;
                }
                yield OFF;
            }
            default -> OFF;
        };
    }

    public InterfaceMode previous(boolean isAdvanced) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case OFF -> {
                if (isAdvanced) {
                    yield SHIELDING;
                }
                yield IRIS;
            }
            case RING_SEGMENT -> OFF;
            case RING_ROTATION -> RING_SEGMENT;
            case CHEVRONS_ACTIVE -> RING_ROTATION;
            case WORMHOLE_ACTIVE -> CHEVRONS_ACTIVE;
            case IRIS -> WORMHOLE_ACTIVE;
            case SHIELDING -> IRIS;
        };
    }
}

