/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.povstalec.sgjourney.common.capabilities.ItemFluidHolderProvider;
import net.povstalec.sgjourney.common.entities.PlasmaProjectile;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.items.FluidItem;
import net.povstalec.sgjourney.common.items.VialItem;

public class StaffWeaponItem
extends FluidItem.Holder {
    public static final String IS_OPEN = "IsOpen";
    private static final float OPEN_ATTACK_DAMAGE = 3.0f;
    private static final float CLOSED_ATTACK_DAMAGE = 6.0f;
    private static final float OPEN_ATTACK_SPEED = -2.4f;
    private static final float CLOSED_ATTACK_SPEED = -2.8f;
    private static final float LIQUID_NAQUADAH_EXPLOSION_POWER = 0.0f;
    private static final float HEAVY_LIQUID_NAQUADAH_EXPLOSION_POWER = 1.0f;
    private static final int LIQUID_NAQUADAH_DEPLETION = 1;
    private static final int HEAVY_LIQUID_NAQUADAH_DEPLETION = 5;
    private final Multimap<Attribute, AttributeModifier> openModifiers;
    private final Multimap<Attribute, AttributeModifier> closedModifiers;

    public StaffWeaponItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder openBuilder = ImmutableMultimap.builder();
        openBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 3.0, AttributeModifier.Operation.ADDITION));
        openBuilder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.openModifiers = openBuilder.build();
        ImmutableMultimap.Builder closedBuilder = ImmutableMultimap.builder();
        closedBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 6.0, AttributeModifier.Operation.ADDITION));
        closedBuilder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.8f, AttributeModifier.Operation.ADDITION));
        this.closedModifiers = closedBuilder.build();
    }

    protected void shoot(Level level, Player player, ItemStack staffWeaponStack) {
        if (!player.m_7500_() && !this.tryDepleteLiquidNaquadah(staffWeaponStack)) {
            return;
        }
        level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundInit.MATOK_FIRE.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
        if (!level.m_5776_()) {
            PlasmaProjectile plasmaProjectile = new PlasmaProjectile((EntityType<? extends Projectile>)((EntityType)EntityInit.JAFFA_PLASMA.get()), (LivingEntity)player, level, this.getExplosionPower(staffWeaponStack));
            plasmaProjectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 5.0f, 1.0f);
            level.m_7967_((Entity)plasmaProjectile);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        player.m_36335_().m_41524_((Item)this, 25);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            ItemStack mainHandStack = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHandStack = player.m_21120_(InteractionHand.OFF_HAND);
            Item item = offHandStack.m_41720_();
            if (item instanceof StaffWeaponItem) {
                StaffWeaponItem staffWeapon = (StaffWeaponItem)item;
                if (!level.m_5776_() && staffWeapon.swapItem(player, offHandStack, mainHandStack)) {
                    return InteractionResultHolder.m_19090_((Object)offHandStack);
                }
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (mainHandStack.m_150930_((Item)ItemInit.MATOK.get())) {
                StaffWeaponItem.setOpen(level, player, mainHandStack, !StaffWeaponItem.isOpen(mainHandStack));
                player.m_36335_().m_41524_((Item)this, 15);
            }
        } else if (StaffWeaponItem.isOpen(stack)) {
            this.shoot(level, player, stack);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public float getExplosionPower(ItemStack stack) {
        return this.getFluidStack(stack).getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get() ? 1.0f : 0.0f;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity player) {
        player.m_9236_().m_5594_((Player)null, player.m_20183_(), (SoundEvent)SoundInit.MATOK_ATTACK.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
        return super.m_7579_(stack, target, player);
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    @Override
    public ItemStack getHeldItem(ItemStack holderStack) {
        IItemHandler itemHandler = holderStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElse(null);
        if (itemHandler == null) {
            return ItemStack.f_41583_;
        }
        return itemHandler.getStackInSlot(0);
    }

    @Override
    public boolean isCorrectFluid(FluidStack fluidStack) {
        return fluidStack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get() || fluidStack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get();
    }

    @Override
    public boolean isValidItem(ItemStack heldStack) {
        return heldStack.m_150930_((Item)ItemInit.VIAL.get());
    }

    public boolean tryDepleteLiquidNaquadah(ItemStack staffWeaponItemStack) {
        FluidStack fluidStack;
        int drainAmount;
        ItemFluidHolderProvider fluidHolder;
        FluidStack depleted;
        IFluidHandlerItem fluidHandler = staffWeaponItemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().orElse(null);
        return fluidHandler instanceof ItemFluidHolderProvider && !(depleted = fluidHolder.deplete(drainAmount = (fluidStack = (fluidHolder = (ItemFluidHolderProvider)fluidHandler).getFluidInTank(0)).getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get() ? 1 : 5, IFluidHandler.FluidAction.EXECUTE)).isEmpty();
    }

    public static boolean isOpen(ItemStack stack) {
        if (stack.m_150930_((Item)ItemInit.MATOK.get())) {
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_(IS_OPEN)) {
                tag.m_128379_(IS_OPEN, false);
                stack.m_41751_(tag);
            }
            return tag.m_128471_(IS_OPEN);
        }
        return false;
    }

    public static void setOpen(Level level, Player player, ItemStack stack, boolean isOpen) {
        if (stack.m_150930_((Item)ItemInit.MATOK.get())) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_(IS_OPEN, isOpen);
            stack.m_41751_(tag);
            level.m_5594_(player, player.m_20183_(), isOpen ? (SoundEvent)SoundInit.MATOK_OPEN.get() : (SoundEvent)SoundInit.MATOK_CLOSE.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return StaffWeaponItem.isOpen(stack) ? this.openModifiers : this.closedModifiers;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        MutableComponent isOpen = StaffWeaponItem.isOpen(stack) ? Component.m_237115_((String)"tooltip.sgjourney.matok.open").m_130940_(ChatFormatting.YELLOW) : Component.m_237115_((String)"tooltip.sgjourney.matok.closed").m_130940_(ChatFormatting.YELLOW);
        tooltipComponents.add((Component)isOpen);
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.matok.open_close").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.matok.reload").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
    }

    public static ItemStack filledStaffWeapon(boolean heavyLiquidNaquadah, int amount) {
        ItemStack staffWeapon = new ItemStack((ItemLike)ItemInit.MATOK.get());
        ItemStack vial = heavyLiquidNaquadah ? VialItem.heavyLiquidNaquadahSetup(amount) : VialItem.liquidNaquadahSetup(amount);
        staffWeapon.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> itemHandler.insertItem(0, vial, false));
        return staffWeapon;
    }
}

