/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonCrystalConfig;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;
import org.jetbrains.annotations.Nullable;

public class TransferCrystalItem
extends AbstractCrystalItem {
    public static final String TRANSFER_LIMIT = "TransferLimit";

    public TransferCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public static CompoundTag tagSetup(long maxTransfer) {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_(TRANSFER_LIMIT, maxTransfer);
        return tag;
    }

    public long getMaxTransfer() {
        return (Long)CommonCrystalConfig.transfer_crystal_max_transfer.get();
    }

    public static long getMaxTransfer(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof TransferCrystalItem) {
            TransferCrystalItem crystal = (TransferCrystalItem)item;
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_(TRANSFER_LIMIT)) {
                tag.m_128356_(TRANSFER_LIMIT, crystal.getMaxTransfer());
            }
            long maxTransfer = tag.m_128435_(TRANSFER_LIMIT) == 3 ? (long)tag.m_128451_(TRANSFER_LIMIT) : tag.m_128454_(TRANSFER_LIMIT);
            return maxTransfer;
        }
        return 0L;
    }

    @Override
    public Optional<Component> descriptionInDHD(ItemStack stack) {
        return Optional.of(Component.m_237115_((String)"tooltip.sgjourney.crystal.in_dhd.transfer").m_7220_((Component)Component.m_237113_((String)(" " + SGJourneyEnergy.energyToString(this.getMaxTransfer())))).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        long maxEnergyTransfer = TransferCrystalItem.getMaxTransfer(stack);
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy_transfer").m_7220_((Component)Component.m_237113_((String)(": " + SGJourneyEnergy.energyToString(maxEnergyTransfer) + "/t"))).m_130940_(ChatFormatting.RED));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static class Advanced
    extends TransferCrystalItem {
        public Advanced(Item.Properties properties) {
            super(properties);
        }

        @Override
        public long getMaxTransfer() {
            return (Long)CommonCrystalConfig.advanced_transfer_crystal_max_transfer.get();
        }

        @Override
        public boolean isAdvanced() {
            return true;
        }
    }
}

