/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.energy_cores;

import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.energy_cores.IEnergyCore;
import org.jetbrains.annotations.Nullable;

public class FusionCoreItem
extends Item
implements IEnergyCore {
    public static final String FUEL = "fuel";

    public FusionCoreItem(Item.Properties properties) {
        super(properties);
    }

    private static boolean showEnergy() {
        return !StargateJourneyConfig.disable_energy_use.get() && (Boolean)CommonTechConfig.fusion_core_infinite_energy.get() == false;
    }

    public boolean m_142522_(ItemStack stack) {
        return FusionCoreItem.showEnergy();
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)FusionCoreItem.getFuel(stack) / (float)FusionCoreItem.getMaxFuel());
    }

    public int m_142159_(ItemStack stack) {
        return 61183;
    }

    public static int getFuel(ItemStack energyCore) {
        if (!energyCore.m_41782_() || !energyCore.m_41783_().m_128441_(FUEL)) {
            return FusionCoreItem.getMaxFuel();
        }
        return energyCore.m_41783_().m_128451_(FUEL);
    }

    public static int getMaxFuel() {
        return (Integer)CommonTechConfig.fusion_core_fuel_capacity.get();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (FusionCoreItem.showEnergy()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.fusion_core.fuel").m_7220_((Component)Component.m_237113_((String)(": " + FusionCoreItem.getFuel(stack) + " / " + FusionCoreItem.getMaxFuel()))).m_130940_(ChatFormatting.AQUA));
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.fusion_core.description").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    @Override
    public long maxGeneratedEnergy(ItemStack energyCore, ItemStack input) {
        return (Long)CommonTechConfig.fusion_core_energy_from_fuel.get();
    }

    @Override
    public long generateEnergy(ItemStack energyCore, ItemStack input) {
        if (((Boolean)CommonTechConfig.fusion_core_infinite_energy.get()).booleanValue()) {
            return this.maxGeneratedEnergy(energyCore, input);
        }
        CompoundTag tag = energyCore.m_41784_();
        if (tag.m_128441_(FUEL)) {
            int fuel = tag.m_128451_(FUEL);
            if (fuel > 0) {
                tag.m_128405_(FUEL, fuel - 1);
                return this.maxGeneratedEnergy(energyCore, input);
            }
            return 0L;
        }
        tag.m_128405_(FUEL, FusionCoreItem.getMaxFuel() - 1);
        return this.maxGeneratedEnergy(energyCore, input);
    }

    public static ItemStack randomFusionCore(int minCapacity, int maxCapacity) {
        ItemStack fusionCore = new ItemStack((ItemLike)ItemInit.FUSION_CORE.get());
        Random random = new Random();
        fusionCore.m_41784_().m_128405_(FUEL, random.nextInt(minCapacity, maxCapacity + 1));
        return fusionCore;
    }
}

