/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.povstalec.sgjourney.common.config.CommonGenerationConfig;
import net.povstalec.sgjourney.common.init.StructureInit;
import net.povstalec.sgjourney.common.misc.SGJourneyJigsawPlacement;
import net.povstalec.sgjourney.common.structures.StargateStructure;

public class StargateVoidStructure
extends StargateStructure {
    public static final Codec<StargateVoidStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StargateVoidStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.BOOL.optionalFieldOf("common_stargates").forGetter(structure -> Optional.ofNullable(structure.commonStargates)), (App)StargateStructure.StargateModifiers.CODEC.optionalFieldOf("stargate_modifiers").forGetter(structure -> Optional.ofNullable(structure.stargateModifiers)), (App)StargateStructure.DHDModifiers.CODEC.optionalFieldOf("dhd_modifiers").forGetter(structure -> Optional.ofNullable(structure.dhdModifiers))).apply((Applicative)instance, StargateVoidStructure::new)).codec();

    public StargateVoidStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Boolean> commonStargates, Optional<StargateStructure.StargateModifiers> stargateModifiers, Optional<StargateStructure.DHDModifiers> dhdModifiers) {
        super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter, commonStargates, stargateModifiers, dhdModifiers);
    }

    @Override
    public boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        int xOffset = (Integer)CommonGenerationConfig.stargate_generation_center_x_chunk_offset.get();
        int zOffset = (Integer)CommonGenerationConfig.stargate_generation_center_z_chunk_offset.get();
        int chunkX = xOffset;
        int chunkZ = zOffset;
        return chunkpos.f_45578_ == chunkX && chunkpos.f_45579_ == chunkZ;
    }

    @Override
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!this.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = 70;
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        Optional structurePiecesGenerator = SGJourneyJigsawPlacement.m_227238_((Structure.GenerationContext)context, (Holder)this.startPool, (Optional)this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, (Optional)this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructureInit.STARGATE_VOID_STRUCTURE.get();
    }
}

