/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MultilineTextFieldWidget
extends AbstractWidget {
    private Consumer<String> responder = s -> {};
    private Pattern filter = null;
    private int maxLength = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_LENGTH = Integer.MAX_VALUE;
    private final Font font;
    private final CachedTextField textField;
    private double scrollAmount;
    private boolean dragging;

    public MultilineTextFieldWidget(Font font, int x, int y, int w, int h, Component placeholder) {
        super(x, y, w, h, placeholder);
        this.font = font;
        this.textField = new CachedTextField(font, w - 4);
        this.textField.m_240162_(Integer.MAX_VALUE);
        this.textField.m_239257_(this::clampScroll);
        this.textField.m_239919_(v -> this.clampScroll());
        this.textField.m_239257_(this::ensureCursorVisible);
    }

    public void setResponder(@NotNull Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFilter(Pattern filter) {
        this.filter = filter;
        String cur = this.getValue();
        String s = this.sanitize(cur);
        if (!s.equals(cur)) {
            this.textField.m_239677_(s);
            this.onEdited();
        }
    }

    public void setMaxLength(int len) {
        this.maxLength = Math.max(0, len);
        String cur = this.getValue();
        if (cur.length() > this.maxLength) {
            this.textField.m_239677_(cur.substring(0, this.maxLength));
            this.onEdited();
        }
    }

    public String getValue() {
        return this.textField.m_239618_();
    }

    public void setValue(String v) {
        String s = this.sanitize(v);
        this.textField.m_239677_(s);
        this.onEdited();
    }

    public boolean m_7933_(int key, int sc, int mod) {
        boolean handled;
        if (!this.m_93696_()) {
            return false;
        }
        if (key == 257 || key == 335) {
            this.textField.m_240015_("\n");
            this.clampScroll();
            this.ensureCursorVisible();
            this.sanitizeAndNotify();
            return true;
        }
        boolean bl = handled = this.textField.m_239711_(key) || Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(key, sc);
        if (handled) {
            this.clampScroll();
            this.ensureCursorVisible();
            this.sanitizeAndNotify();
            return true;
        }
        return false;
    }

    public boolean m_5534_(char chr, int mods) {
        if (!this.m_93696_()) {
            return false;
        }
        if (chr == '\n' || chr == '\r') {
            return true;
        }
        if (this.filter != null && !this.filter.matcher(String.valueOf(chr)).matches()) {
            return true;
        }
        this.textField.m_240015_(String.valueOf(chr));
        this.clampScroll();
        this.ensureCursorVisible();
        this.sanitizeAndNotify();
        return true;
    }

    public boolean m_6375_(double mx, double my, int btn) {
        if (!(this.m_142518_() && this.m_7972_(btn) && this.m_93680_(mx, my))) {
            return false;
        }
        Minecraft.m_91087_().f_91080_.m_7522_((GuiEventListener)this);
        this.m_93692_(true);
        if (!Screen.m_96638_()) {
            this.textField.m_239950_(false);
        }
        this.moveCursorToMouse(mx, my);
        this.textField.m_239950_(true);
        this.dragging = true;
        return true;
    }

    public boolean m_6348_(double mx, double my, int btn) {
        this.dragging = false;
        this.textField.m_239950_(false);
        return super.m_6348_(mx, my, btn);
    }

    public boolean m_7979_(double mx, double my, int btn, double dx, double dy) {
        if (this.dragging && this.m_93696_()) {
            this.moveCursorToMouse(mx, my);
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mx, double my, double delta) {
        if (!this.m_5953_(mx, my)) {
            return false;
        }
        Objects.requireNonNull(this.font);
        this.setScrollAmount(this.scrollAmount - delta * 9.0);
        return true;
    }

    protected void m_87963_(GuiGraphics g, int mX, int mY, float partial) {
        Line ln;
        int bg = -14671840;
        int border = this.m_93696_() ? -1 : -8355712;
        g.m_285944_(RenderType.m_286086_(), this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, bg);
        g.m_285944_(RenderType.m_286086_(), this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + 1, border);
        g.m_285944_(RenderType.m_286086_(), this.m_252754_(), this.m_252907_() + this.f_93619_ - 1, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, border);
        g.m_285944_(RenderType.m_286086_(), this.m_252754_(), this.m_252907_(), this.m_252754_() + 1, this.m_252907_() + this.f_93619_, border);
        g.m_285944_(RenderType.m_286086_(), this.m_252754_() + this.f_93618_ - 1, this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, border);
        int clipL = this.m_252754_() + 2;
        int clipT = this.m_252907_() + 2;
        int clipR = this.m_252754_() + this.f_93618_ - 2;
        int clipB = this.m_252907_() + this.f_93619_ - 2;
        g.m_280588_(clipL, clipT, clipR, clipB);
        Objects.requireNonNull(this.font);
        int firstLine = (int)(this.scrollAmount / 9.0);
        int n = clipT - (int)this.scrollAmount;
        Objects.requireNonNull(this.font);
        int y = n + firstLine * 9;
        int selectionBegin = this.textField.m_239344_() ? this.textField.selection().begin() : -1;
        int selectionEnd = this.textField.m_239344_() ? this.textField.selection().end() : -1;
        int selectionColor = -2147450881;
        if (this.m_93696_() && this.blink()) {
            int curLine = this.textField.lineAtCursor();
            ln = this.textField.line(curLine);
            int cx = clipL + this.font.m_92895_(this.textField.m_239618_().substring(ln.begin(), this.textField.m_239456_()));
            Objects.requireNonNull(this.font);
            int cy = clipT + curLine * 9 - (int)this.scrollAmount;
            if (cy >= clipT && cy < clipB) {
                Objects.requireNonNull(this.font);
                g.m_280509_(cx, cy, cx + 1, cy + 9, -1);
            }
        }
        for (int idx = firstLine; idx < this.textField.lineCount() && y <= clipB; y += 9, ++idx) {
            ln = this.textField.line(idx);
            String str = this.textField.m_239618_().substring(ln.begin(), ln.end());
            int xOff = clipL;
            g.m_280488_(this.font, str, xOff, y, -2039584);
            if (this.textField.m_239344_()) {
                int selEndInLine;
                int selStartInLine;
                int lineStartChar = ln.begin();
                int lineEndChar = ln.end();
                if (selectionEnd > lineStartChar && selectionBegin < lineEndChar && (selStartInLine = Math.max(0, selectionBegin - lineStartChar)) < (selEndInLine = Math.min(str.length(), selectionEnd - lineStartChar))) {
                    String preSel = str.substring(0, selStartInLine);
                    String selectionText = str.substring(selStartInLine, selEndInLine);
                    int selX = xOff + this.font.m_92895_(preSel);
                    int selW = this.font.m_92895_(selectionText);
                    RenderType renderType = RenderType.m_285783_();
                    Objects.requireNonNull(this.font);
                    g.m_285944_(renderType, selX, y, selX + selW, y + 9, selectionColor);
                }
            }
            Objects.requireNonNull(this.font);
        }
        g.m_280618_();
        if (this.textField.m_239618_().isEmpty() && !this.m_93696_()) {
            g.m_280430_(this.font, this.m_6035_(), clipL, clipT, -8355712);
        }
    }

    protected void m_168797_(@NotNull NarrationElementOutput out) {
    }

    public double getMaxScroll() {
        int n = this.textField.lineCount();
        Objects.requireNonNull(this.font);
        int textH = n * 9;
        return Math.max(textH - (this.f_93619_ - 4), 0);
    }

    public void setScrollAmount(double a) {
        this.scrollAmount = Mth.m_14008_((double)a, (double)0.0, (double)this.getMaxScroll());
    }

    private void clampScroll() {
        this.setScrollAmount(this.scrollAmount);
    }

    private void ensureCursorVisible() {
        int viewH = this.f_93619_ - 4;
        int caretLine = this.textField.lineAtCursor();
        Objects.requireNonNull(this.font);
        int caretY = caretLine * 9;
        double top = this.scrollAmount;
        double d = this.scrollAmount + (double)viewH;
        Objects.requireNonNull(this.font);
        double bottom = d - 9.0;
        if ((double)caretY < top) {
            this.setScrollAmount(caretY);
        } else if ((double)caretY > bottom) {
            Objects.requireNonNull(this.font);
            this.setScrollAmount(caretY - (viewH - 9));
        }
    }

    private void sanitizeAndNotify() {
        String cur = this.getValue();
        String s = this.sanitize(cur);
        if (!s.equals(cur)) {
            this.textField.m_239677_(s);
        }
        this.onEdited();
    }

    private void onEdited() {
        try {
            this.responder.accept(this.getValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String sanitize(String in) {
        if (in == null) {
            return "";
        }
        StringBuilder b = new StringBuilder(in.length());
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '\r') continue;
            if (c == '\n') {
                b.append('\n');
                continue;
            }
            if (this.filter != null && !this.filter.matcher(String.valueOf(c)).matches()) continue;
            b.append(c);
        }
        String s = b.toString();
        if (s.length() > this.maxLength) {
            s = s.substring(0, this.maxLength);
        }
        return s;
    }

    private void moveCursorToMouse(double mx, double my) {
        double relX = mx - (double)(this.m_252754_() + 2);
        double relY = my - (double)(this.m_252907_() + 2) + this.scrollAmount;
        this.textField.m_239578_(relX, relY);
    }

    private boolean blink() {
        return Util.m_137550_() / 500L % 2L == 0L;
    }

    private static final class CachedTextField
    extends MultilineTextField {
        private List<Line> cache = new ArrayList<Line>();

        CachedTextField(Font font, int w) {
            super(font, w);
            this.rebuild();
        }

        int lineCount() {
            return this.cache.size();
        }

        Line line(int idx) {
            return this.cache.get(Mth.m_14045_((int)idx, (int)0, (int)(this.cache.size() - 1)));
        }

        int lineAtCursor() {
            return super.m_239268_();
        }

        Selection selection() {
            MultilineTextField.StringView sv = super.m_239982_();
            return new Selection(sv.f_238590_(), sv.f_238654_());
        }

        public void m_239677_(@NotNull String v) {
            super.m_239677_(v);
            this.rebuild();
        }

        public void m_240015_(@NotNull String t) {
            super.m_240015_(t);
            this.rebuild();
        }

        private void rebuild() {
            if (this.cache == null) {
                this.cache = new ArrayList<Line>();
            }
            this.cache.clear();
            super.m_239290_().forEach(sv -> this.cache.add(new Line(sv.f_238590_(), sv.f_238654_())));
        }

        record Selection(int begin, int end) {
        }
    }

    private record Line(int begin, int end) {
    }
}

