/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.config.Actionable;
import appeng.api.config.Setting;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.util.IConfigManager;
import appeng.helpers.IConfigInvHost;
import appeng.me.storage.NullInventory;
import appeng.parts.PartModel;
import appeng.util.ConfigInventory;
import appeng.util.SettingsFrom;
import appeng.util.prioritylist.IPartitionList;
import com.glodblock.github.extendedae.common.parts.base.PartSpecialStorageBus;
import com.glodblock.github.extendedae.container.ContainerPreciseStorageBus;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public class PartPreciseStorageBus
extends PartSpecialStorageBus
implements IConfigInvHost {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("expatternprovider", "part/precise_storage_bus_base");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_off")});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_on")});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_has_channel")});
    private final ConfigInventory config = ConfigInventory.configStacks(null, (int)63, this::onConfigurationChanged, (boolean)true);

    public PartPreciseStorageBus(IPartItem<?> partItem) {
        super(partItem);
    }

    protected void onConfigurationChanged() {
        if (this.getMainNode().isReady()) {
            this.updateTarget(true);
        }
    }

    @Override
    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.onConfigurationChanged();
        this.getHost().markForSave();
    }

    @Override
    public void upgradesChanged() {
        super.upgradesChanged();
        this.onConfigurationChanged();
    }

    @Override
    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.config.readFromChildTag(data, "config");
    }

    @Override
    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        this.config.writeToChildTag(data, "config");
    }

    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        this.config.readFromChildTag(input, "config");
    }

    public void exportSettings(SettingsFrom mode, CompoundTag output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.config.writeToChildTag(output, "config");
        }
    }

    public ConfigInventory getConfig() {
        return this.config;
    }

    @Override
    protected IPartitionList createFilter() {
        return new PreciseFilter(this.config.getAvailableStacks());
    }

    @Override
    public MenuType<?> getMenuType() {
        return ContainerPreciseStorageBus.TYPE;
    }

    @Override
    protected PartSpecialStorageBus.StorageBusInventory createHandler() {
        return new PreciseInventory(NullInventory.of());
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public MEStorage getInternalHandler() {
        return this.handler.getDelegate();
    }

    public static class PreciseFilter
    implements IPartitionList {
        private final KeyCounter filter;

        public PreciseFilter(KeyCounter counter) {
            this.filter = counter;
        }

        public boolean isListed(AEKey input) {
            return this.filter.get(input) > 0L;
        }

        public boolean isEmpty() {
            return this.filter.isEmpty();
        }

        public Iterable<AEKey> getItems() {
            return this.filter.keySet();
        }

        public long getAmount(AEKey input) {
            return this.filter.get(input);
        }
    }

    public static class PreciseInventory
    extends PartSpecialStorageBus.StorageBusInventory {
        public PreciseInventory(MEStorage inventory) {
            super(inventory);
        }

        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            IPartitionList filter = this.getPartitionList();
            long toAdd = 0L;
            if (filter instanceof PreciseFilter) {
                PreciseFilter p = (PreciseFilter)filter;
                toAdd = p.getAmount(what);
            }
            if (toAdd <= 0L) {
                return 0L;
            }
            if ((toAdd -= this.getAvailableStacks().get(what)) <= 0L) {
                return 0L;
            }
            toAdd = Math.min(amount, toAdd);
            return super.insert(what, toAdd, mode, source);
        }
    }
}

