/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.behaviors.ContainerItemContext;
import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.StackExportStrategy;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.capabilities.Capabilities;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.helpers.externalstorage.GenericStackFluidStorage;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import com.glodblock.github.extendedae.api.CanerMode;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import com.glodblock.github.glodium.util.GlodUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileCaner
extends AENetworkPowerBlockEntity
implements IGridTickable,
ICraftingMachine {
    public static final int POWER_MAXIMUM_AMOUNT = 3200;
    public static final int POWER_USAGE = 80;
    private final AppEngInternalInventory container = new AppEngInternalInventory((InternalInventoryHost)this, 1, 1);
    private final GenericStackInv stuff = new GenericStackInv(this::wake, 1);
    private ItemStack target = ItemStack.f_41583_;
    private Direction ejectSide = null;
    private CanerMode mode = CanerMode.FILL;
    private AEKey emptyKey = null;

    public TileCaner(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileCaner.class, TileCaner::new, (Block)EPPItemAndBlock.CANER), pos, blockState);
        this.stuff.useRegisteredCapacities();
        this.stuff.setCapacity(AEKeyType.items(), 0L);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(3200.0);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
    }

    public AppEngInternalInventory getContainer() {
        return this.container;
    }

    public GenericStackInv getStuff() {
        return this.stuff;
    }

    public CanerMode getMode() {
        return this.mode;
    }

    public void setMode(CanerMode mode) {
        this.mode = mode;
    }

    @Nullable
    private ContainerItemContext getStrategy(AEKey type, Player player, ItemStack target) {
        if (ContainerItemStrategies.isKeySupported((AEKey)type)) {
            return ContainerItemStrategies.findOwnedItemContext((AEKeyType)type.getType(), (Player)player, (ItemStack)target);
        }
        return null;
    }

    public boolean isDone() {
        if (!this.target.m_41619_()) {
            return this.target.equals(this.container.getStackInSlot(0), false);
        }
        return false;
    }

    private void eject() {
        ItemTransfer target;
        if (this.f_58857_ instanceof ServerLevel && !this.container.getStackInSlot(0).m_41619_() && this.ejectSide != null && (target = InternalInventory.wrapExternal((Level)this.f_58857_, (BlockPos)this.m_58899_().m_121945_(this.ejectSide), (Direction)this.ejectSide.m_122424_())) != null) {
            int startItems = this.container.getStackInSlot(0).m_41613_();
            this.container.insertItem(0, target.addItems(this.container.extractItem(0, 64, false)), false);
            int endItems = this.container.getStackInSlot(0).m_41613_();
            long pushed = 0L;
            long origin = 0L;
            if (this.stuff.getStack(0) != null) {
                StackExportStrategy genTarget = StackWorldBehaviors.createExportFacade((ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)this.m_58899_().m_121945_(this.ejectSide), (Direction)this.ejectSide.m_122424_());
                GenericStack obj = this.stuff.getStack(0);
                origin = obj.amount();
                pushed = genTarget.push(obj.what(), origin, Actionable.MODULATE);
                this.stuff.extract(0, obj.what(), pushed, Actionable.MODULATE);
            }
            if (startItems != endItems && pushed == origin) {
                this.target = ItemStack.f_41583_;
                this.emptyKey = null;
            }
        }
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.of(orientation.getSide(RelativeSide.TOP), orientation.getSide(RelativeSide.BOTTOM));
    }

    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.setPowerSides(this.getGridConnectableSides(orientation));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (Capabilities.CRAFTING_MACHINE == capability) {
            return Capabilities.CRAFTING_MACHINE.orEmpty(capability, LazyOptional.of(() -> this));
        }
        if (capability == Capabilities.GENERIC_INTERNAL_INV) {
            return LazyOptional.of(this::getStuff).cast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(this::getStuff).lazyMap(GenericStackFluidStorage::new).cast();
        }
        return super.getCapability(capability, facing);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 1, !this.hasJob(), true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.markForUpdate();
        if (this.getInternalCurrentPower() < 3200.0) {
            this.getMainNode().ifPresent(grid -> {
                double toExtract = Math.min(80.0, this.getInternalMaxPower() - this.getInternalCurrentPower());
                double extracted = grid.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                this.injectExternalPower(PowerUnits.AE, extracted, Actionable.MODULATE);
            });
        }
        if (this.mode == CanerMode.FILL) {
            this.fill();
        } else if (this.mode == CanerMode.EMPTY) {
            this.empty();
        }
        if (this.isDone()) {
            this.eject();
        }
        return TickRateModulation.FASTER;
    }

    public InternalInventory getInternalInventory() {
        return this.container;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.container) {
            this.wake();
        }
    }

    private void wake() {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.stuff.writeToChildTag(data, "stuff");
        data.m_128365_("target", (Tag)this.target.m_41739_(new CompoundTag()));
        if (this.ejectSide != null) {
            data.m_128359_("ejectSide", this.ejectSide.name());
        }
        data.m_128344_("mode", (byte)this.mode.ordinal());
        if (this.emptyKey != null) {
            data.m_128365_("emptyKey", (Tag)this.emptyKey.toTag());
        }
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.stuff.readFromChildTag(data, "stuff");
        if (data.m_128441_("target")) {
            this.target = ItemStack.m_41712_((CompoundTag)data.m_128469_("target"));
        }
        if (data.m_128441_("ejectSide")) {
            this.ejectSide = Direction.valueOf((String)data.m_128461_("ejectSide"));
        }
        if (data.m_128441_("mode")) {
            this.mode = CanerMode.values()[data.m_128445_("mode")];
        }
        if (data.m_128441_("emptyKey")) {
            this.emptyKey = AEKey.fromTagGeneric((CompoundTag)data.m_128469_("emptyKey"));
        }
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        GenericStack stack = this.stuff.getStack(0);
        if (stack != null) {
            stack.what().addDrops(stack.amount(), drops, level, pos);
        }
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        this.container.setItemDirect(0, data.m_130267_());
        return changed;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.m_130055_(this.container.getStackInSlot(0));
    }

    private void fill() {
        long added;
        ItemStack stack = this.container.getStackInSlot(0);
        GenericStack obj = this.stuff.getStack(0);
        if (stack.m_41619_() || obj == null) {
            return;
        }
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return;
        }
        Player player = Platform.getFakePlayer((ServerLevel)((ServerLevel)this.f_58857_), null);
        player.m_150109_().m_6836_(0, stack);
        player.m_150109_().m_6836_(1, ItemStack.f_41583_);
        ContainerItemContext handler = this.getStrategy(obj.what(), player, stack);
        if (handler == null) {
            return;
        }
        if (this.getInternalCurrentPower() >= 80.0 && (added = handler.insert(obj.what(), obj.amount(), Actionable.SIMULATE)) > 0L) {
            this.stuff.extract(0, obj.what(), added, Actionable.MODULATE);
            handler.insert(obj.what(), added, Actionable.MODULATE);
            if (!player.m_150109_().m_8020_(0).m_41619_()) {
                this.container.setItemDirect(0, player.m_150109_().m_8020_(0).m_41777_());
            } else {
                this.container.setItemDirect(0, player.m_150109_().m_8020_(1).m_41777_());
            }
            this.extractAEPower(80.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
    }

    private void empty() {
        long canAdd;
        long toAdd;
        ItemStack stack = this.container.getStackInSlot(0);
        GenericStack obj = this.stuff.getStack(0);
        if (stack.m_41619_()) {
            return;
        }
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return;
        }
        GenericStack contents = this.emptyKey != null ? ContainerItemStrategies.getContainedStack((ItemStack)stack, (AEKeyType)this.emptyKey.getType()) : ContainerItemStrategies.getContainedStack((ItemStack)stack);
        if (contents == null) {
            return;
        }
        if (obj != null && !obj.what().equals(contents.what())) {
            return;
        }
        Player player = Platform.getFakePlayer((ServerLevel)((ServerLevel)this.f_58857_), null);
        player.m_150109_().m_6836_(0, stack);
        player.m_150109_().m_6836_(1, ItemStack.f_41583_);
        ContainerItemContext handler = this.getStrategy(contents.what(), player, stack);
        if (handler == null) {
            return;
        }
        if (this.getInternalCurrentPower() >= 80.0 && (toAdd = handler.extract(contents.what(), contents.amount(), Actionable.SIMULATE)) > 0L && (canAdd = this.stuff.insert(0, contents.what(), toAdd, Actionable.SIMULATE)) == toAdd) {
            handler.extract(contents.what(), canAdd, Actionable.MODULATE);
            this.stuff.insert(0, contents.what(), canAdd, Actionable.MODULATE);
            if (!player.m_150109_().m_8020_(0).m_41619_()) {
                this.container.setItemDirect(0, player.m_150109_().m_8020_(0).m_41777_());
            } else {
                this.container.setItemDirect(0, player.m_150109_().m_8020_(1).m_41777_());
            }
            this.extractAEPower(80.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
    }

    private boolean hasJob() {
        if (this.mode == CanerMode.FILL) {
            return this.stuff.getStack(0) != null && !this.container.getStackInSlot(0).m_41619_();
        }
        if (this.mode == CanerMode.EMPTY) {
            return !this.container.getStackInSlot(0).m_41619_();
        }
        return false;
    }

    public PatternContainerGroup getCraftingMachineInfo() {
        Component name = this.m_8077_() ? this.m_7770_() : EPPItemAndBlock.CANER.m_5456_().m_41466_();
        return new PatternContainerGroup(AEItemKey.of((ItemLike)EPPItemAndBlock.CANER), name, List.of());
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputs, Direction ejectionDirection) {
        if (patternDetails instanceof AEProcessingPattern && this.stuff.getStack(0) == null && this.container.getStackInSlot(0).m_41619_()) {
            if (this.mode == CanerMode.FILL) {
                if (inputs.length == 2 && inputs[0].getFirstEntry() != null && inputs[1].getFirstEntry() != null) {
                    boolean fail;
                    Object2LongMap.Entry obj = inputs[0].getFirstEntry();
                    Object2LongMap.Entry cnt = inputs[1].getFirstEntry();
                    GenericStack rst = patternDetails.getPrimaryOutput();
                    if (obj.getKey() instanceof AEItemKey) {
                        obj = inputs[1].getFirstEntry();
                        cnt = inputs[0].getFirstEntry();
                    }
                    if (!(cnt.getKey() instanceof AEItemKey) || cnt.getLongValue() != 1L) {
                        return false;
                    }
                    if (!(rst.what() instanceof AEItemKey) || rst.amount() != 1L) {
                        return false;
                    }
                    this.stuff.setStack(0, new GenericStack((AEKey)obj.getKey(), obj.getLongValue()));
                    this.container.setItemDirect(0, ((AEItemKey)cnt.getKey()).toStack());
                    boolean bl = fail = this.stuff.getStack(0) == null || this.stuff.getStack(0).amount() != obj.getLongValue();
                    if (this.container.getStackInSlot(0).m_41619_()) {
                        fail = true;
                    }
                    if (fail) {
                        this.stuff.setStack(0, null);
                        this.container.setItemDirect(0, ItemStack.f_41583_);
                        return false;
                    }
                    this.target = ((AEItemKey)rst.what()).toStack();
                    this.ejectSide = ejectionDirection;
                    return true;
                }
            } else if (this.mode == CanerMode.EMPTY && inputs.length == 1 && patternDetails.getOutputs().length == 2 && inputs[0].getFirstEntry() != null) {
                boolean fail;
                Object2LongMap.Entry cnt = inputs[0].getFirstEntry();
                GenericStack obj = patternDetails.getOutputs()[0];
                GenericStack rst = patternDetails.getOutputs()[1];
                if (obj.what() instanceof AEItemKey) {
                    obj = patternDetails.getOutputs()[1];
                    rst = patternDetails.getOutputs()[0];
                }
                if (!(cnt.getKey() instanceof AEItemKey) || cnt.getLongValue() != 1L) {
                    return false;
                }
                if (!(rst.what() instanceof AEItemKey) || rst.amount() != 1L) {
                    return false;
                }
                this.container.setItemDirect(0, ((AEItemKey)cnt.getKey()).toStack());
                boolean bl = fail = this.container.getStackInSlot(0).m_41619_() || obj == null;
                if (!fail) {
                    this.target = ((AEItemKey)rst.what()).toStack();
                    this.emptyKey = obj.what();
                    this.ejectSide = ejectionDirection;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean acceptsPlans() {
        return true;
    }
}

