/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.config;

import appeng.api.stacks.AEKey;
import com.glodblock.github.extendedae.util.FCUtil;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="expatternprovider", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EPPConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.IntValue EX_BUS_SPEED = BUILDER.comment("ME Extend Import/Export Bus speed multiplier").defineInRange("exBusMultiplier", 8, 2, 128);
    private static final ForgeConfigSpec.DoubleValue INFINITY_CELL_ENERGY = BUILDER.comment("ME Infinity Cell idle energy cost (unit: AE/t)").defineInRange("cost", 8.0, 0.1, 64.0);
    private static final ForgeConfigSpec.DoubleValue WIRELESS_CONNECTOR_RANGE = BUILDER.comment("The max range between two wireless connector").defineInRange("range", 1000.0, 10.0, 10000.0);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> INFINITY_CELL_TYPES = BUILDER.comment("ME Infinity Cell types (item or fluid's id)").defineList("types", (List)Lists.newArrayList((Object[])new String[]{"minecraft:water", "minecraft:cobblestone"}), EPPConfig::checkRL);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> PACKABLE_AE_DEVICE = BUILDER.comment("The AE device/part that can be packed by ME Packing Tape").defineList("whitelist", (List)Lists.newArrayList((Object[])new String[]{"expatternprovider:ex_interface_part", "expatternprovider:ex_pattern_provider_part", "expatternprovider:ex_interface", "expatternprovider:ex_pattern_provider", "expatternprovider:ex_drive", "ae2:cable_interface", "ae2:cable_pattern_provider", "ae2:interface", "ae2:pattern_provider", "ae2:drive"}), o -> true);
    private static final ForgeConfigSpec.BooleanValue INSCRIBER_RENDER = BUILDER.comment("Disable Extended Inscriber's item render, it only works in client side.").define("disableItemRender", false);
    private static final ForgeConfigSpec.IntValue OVERSIZE_MULTIPLIER = BUILDER.comment("Size multiplier of oversize interface").defineInRange("device.oversize_interface_multiplier", 16, 2, 4096);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> CUSTOM_OVERSIZE_MULTIPLIER = BUILDER.comment("Set multiplier for specific AEKeyType in oversize interface").defineList("device.custom_oversize_interface_multiplier", (List)Lists.newArrayList((Object[])new String[]{"appbot:mana 2", "appflux:flux 4"}), o -> true);
    private static final ForgeConfigSpec.IntValue ASSEMBLER_MATRIX_SIZE = BUILDER.comment("The max size of Assembler Matrix").defineInRange("device.assembler_matrix_max_size", 6, 3, 16);
    private static final ForgeConfigSpec.BooleanValue DEBUG_MODE = BUILDER.comment("Enable debug logging.").define("misc.debug_mode", false);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static int busSpeed;
    public static double infCellCost;
    public static double wirelessMaxRange;
    public static List<Fluid> infCellFluid;
    public static List<Item> infCellItem;
    public static List<ResourceLocation> tapeWhitelist;
    public static boolean disableInscriberRender;
    private static int oversizeMultiplier;
    private static Map<ResourceLocation, Integer> customOversizeMultiplier;
    public static int assemblerMatrixSize;
    public static boolean debugMode;

    private static boolean checkRL(Object o) {
        String s;
        return o instanceof String && (FCUtil.checkInvalidRL(s = (String)o, ForgeRegistries.ITEMS) || FCUtil.checkInvalidRL(s, ForgeRegistries.FLUIDS));
    }

    public static int getOversizeMultiplier(AEKey key) {
        return customOversizeMultiplier.getOrDefault(key.getType().getId(), oversizeMultiplier);
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        busSpeed = (Integer)EX_BUS_SPEED.get();
        infCellCost = (Double)INFINITY_CELL_ENERGY.get();
        wirelessMaxRange = (Double)WIRELESS_CONNECTOR_RANGE.get();
        infCellFluid = new ArrayList<Fluid>();
        infCellItem = new ArrayList<Item>();
        ((List)INFINITY_CELL_TYPES.get()).forEach(s -> {
            if (FCUtil.checkInvalidRL(s, ForgeRegistries.ITEMS)) {
                infCellItem.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s)));
            }
            if (FCUtil.checkInvalidRL(s, ForgeRegistries.FLUIDS)) {
                infCellFluid.add((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(s)));
            }
        });
        tapeWhitelist = ((List)PACKABLE_AE_DEVICE.get()).stream().map(ResourceLocation::new).collect(Collectors.toList());
        disableInscriberRender = (Boolean)INSCRIBER_RENDER.get();
        oversizeMultiplier = (Integer)OVERSIZE_MULTIPLIER.get();
        customOversizeMultiplier = new Object2IntOpenHashMap();
        ((List)CUSTOM_OVERSIZE_MULTIPLIER.get()).stream().map(EPPConfig::parseOversizeMultiplier).filter(Objects::nonNull).forEach(p -> customOversizeMultiplier.put((ResourceLocation)p.getKey(), (Integer)p.getValue()));
        assemblerMatrixSize = (Integer)ASSEMBLER_MATRIX_SIZE.get();
        debugMode = (Boolean)DEBUG_MODE.get();
    }

    private static Pair<ResourceLocation, Integer> parseOversizeMultiplier(String s) {
        try {
            String[] pair = s.split(" ");
            return Pair.of((Object)new ResourceLocation(pair[0]), (Object)Integer.decode(pair[1]));
        }
        catch (Throwable t) {
            return null;
        }
    }
}

