/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.farmingforblockheads.block.FertilizedFarmlandBlock;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FertilizerItem
extends Item {
    private final FertilizerType fertilizerType;

    public FertilizerItem(FertilizerType fertilizerType) {
        super(new Item.Properties());
        this.fertilizerType = fertilizerType;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack heldItem = context.m_43722_();
        if (this.tryApplyFertilizerAt(level, pos) || this.tryApplyFertilizerAt(level, pos.m_7495_())) {
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    private boolean tryApplyFertilizerAt(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        BlockState newState = this.fertilizerType.applyFertilizer(state);
        if (newState != state) {
            world.m_46597_(pos, newState);
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent chatComponent = Component.m_237115_((String)("tooltip.farmingforblockheads:fertilizer_" + this.fertilizerType.name().toLowerCase(Locale.ENGLISH)));
        chatComponent.m_130940_(this.fertilizerType.getFarmlandTrait().getTraitColor());
        tooltip.add((Component)chatComponent);
    }

    public static enum FertilizerType {
        HEALTHY,
        RICH,
        STABLE;


        public boolean canFertilize(BlockState state) {
            Block sourceBlock = state.m_60734_();
            return sourceBlock == Blocks.f_50093_ || sourceBlock instanceof FertilizedFarmlandBlock;
        }

        public BlockState applyFertilizer(BlockState state) {
            Block targetBlock;
            if (!this.canFertilize(state)) {
                return state;
            }
            int moisture = (Integer)state.m_61143_((Property)BlockStateProperties.f_61423_);
            ArrayList<FertilizedFarmlandBlock.FarmlandTrait> traits = new ArrayList<FertilizedFarmlandBlock.FarmlandTrait>();
            traits.add(this.getFarmlandTrait());
            Block sourceBlock = state.m_60734_();
            if (sourceBlock instanceof FertilizedFarmlandBlock) {
                traits.addAll(((FertilizedFarmlandBlock)sourceBlock).getTraits());
            }
            if ((targetBlock = FertilizerType.getBlockForTraits(traits)) == null) {
                return state;
            }
            BlockState newState = targetBlock.m_49966_();
            return (BlockState)newState.m_61124_((Property)FertilizedFarmlandBlock.f_53243_, (Comparable)Integer.valueOf(moisture));
        }

        private FertilizedFarmlandBlock.FarmlandTrait getFarmlandTrait() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEALTHY -> new FertilizedFarmlandBlock.FarmlandHealthyTrait();
                case RICH -> new FertilizedFarmlandBlock.FarmlandRichTrait();
                case STABLE -> new FertilizedFarmlandBlock.FarmlandStableTrait();
            };
        }

        @Nullable
        private static Block getBlockForTraits(List<FertilizedFarmlandBlock.FarmlandTrait> traits) {
            boolean hasStableTrait = traits.stream().anyMatch(it -> it instanceof FertilizedFarmlandBlock.FarmlandStableTrait);
            boolean hasHealthyTrait = traits.stream().anyMatch(it -> it instanceof FertilizedFarmlandBlock.FarmlandHealthyTrait);
            boolean hasRichTrait = traits.stream().anyMatch(it -> it instanceof FertilizedFarmlandBlock.FarmlandRichTrait);
            if (hasStableTrait && !hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandStable;
            }
            if (!hasStableTrait && hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandRich;
            }
            if (!hasStableTrait && !hasRichTrait && hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandHealthy;
            }
            if (hasStableTrait && hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandRichStable;
            }
            if (hasStableTrait && !hasRichTrait && hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandHealthyStable;
            }
            return null;
        }
    }
}

