/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blocks;

import earth.terrarium.adastra.client.screens.blocks.FlagUrlScreen;
import earth.terrarium.adastra.common.blockentities.flag.FlagBlockEntity;
import earth.terrarium.adastra.common.blocks.base.BasicEntityBlock;
import earth.terrarium.adastra.common.blocks.properties.EightDirectionProperty;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlagBlock
extends BasicEntityBlock
implements SimpleWaterloggedBlock {
    public static final EightDirectionProperty FACING = EightDirectionProperty.FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_BOTTOM = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_TOP = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)24.0, (double)9.0);

    public FlagBlock(BlockBehaviour.Properties properties) {
        super(properties, false);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FACING, (Comparable)((Object)EightDirectionProperty.Direction.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, HALF});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.FLAG_INFO);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_() && (AdAstraConfig.allowFlagImages || player.m_36337_())) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                return this.action(level, pos.m_7494_(), player);
            }
            return this.action(level, pos, player);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private InteractionResult action(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FlagBlockEntity) {
            FlagBlockEntity entity = (FlagBlockEntity)blockEntity;
            if (entity.getOwner() != null && player.m_20148_().equals(entity.getOwner().getId())) {
                FlagUrlScreen.open(pos);
            } else {
                player.m_5661_(ConstantComponents.NOT_THE_OWNER, true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return Block.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_()) && level.m_8055_(pos.m_7494_()).m_60795_();
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.m_5776_() && player.m_7500_()) {
            FlagBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
        }
        super.m_5707_(level, pos, state, player);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? SHAPE_BOTTOM : SHAPE_TOP;
    }

    @Override
    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(HALF) != half ? (BlockState)state.m_61124_((Property)FACING, (Comparable)((Object)((EightDirectionProperty.Direction)((Object)neighborState.m_61143_((Property)FACING))))) : Blocks.f_50016_.m_49966_();
        }
        return half == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            EightDirectionProperty.Direction direction = EightDirectionProperty.Direction.VALUES[Mth.m_14107_((double)((double)(context.m_7074_() * 8.0f / 360.0f) + 0.5)) & 7];
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)((Object)direction));
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        level.m_46597_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER));
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos.m_7494_());
            if (blockEntity instanceof FlagBlockEntity) {
                FlagBlockEntity flagEntity = (FlagBlockEntity)blockEntity;
                flagEntity.setOwner(player.m_36316_());
            }
        }
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }
}

