/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class ElectromagnetBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IScrewdriverInteraction {
    public MutableEnergyStorage energyStorage = new MutableEnergyStorage(32000);
    private final ResettableCapability<IEnergyStorage> energyCap = this.registerEnergyInput(this.energyStorage);
    public boolean redstoneControlInverted = false;
    public static final int MAGNET_CONSUMPTION = 32;
    public static final LoadingCache<String, Predicate<ItemEntity>> MAGNET_SOURCE_PREDICATE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(20L, TimeUnit.MINUTES).build(CacheLoader.from(key -> itemEntity -> {
        if (itemEntity.m_32063_()) {
            return false;
        }
        int lastMagnetized = itemEntity.getPersistentData().m_128451_("immersiveengineering:magnet_last_pulled");
        if (lastMagnetized > 0 && itemEntity.f_19797_ - lastMagnetized < 40) {
            return false;
        }
        String nbtSource = itemEntity.getPersistentData().m_128461_("immersiveengineering:magnet_source");
        if (!nbtSource.isEmpty() && !nbtSource.equals(key)) {
            return false;
        }
        return !itemEntity.getPersistentData().m_128441_("PreventRemoteMovement");
    }));

    public ElectromagnetBlockEntity(BlockEntityType<? extends ElectromagnetBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ElectromagnetBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends ElectromagnetBlockEntity>)((BlockEntityType)IEBlockEntities.ELECTROMAGNET.get()), pos, state);
    }

    @Override
    public void tickServer() {
        if (this.isRSPowered() == this.redstoneControlInverted && this.energyStorage.extractEnergy(32, false) >= 32) {
            AABB area;
            int radius = 6;
            Direction facing = this.getFacing();
            Vec3 sourcePos = this.m_58899_().m_121945_(facing).m_252807_().m_82520_(0.0, 0.25, 0.0);
            if (this.getFacing().m_122434_() != Direction.Axis.Y) {
                bottomClose = this.m_58899_().m_5484_(facing.m_122428_(), 6).m_6625_(6);
                BlockPos topFar = this.m_58899_().m_5484_(facing, 6).m_5484_(facing.m_122427_(), 6).m_6630_(6);
                area = new AABB(bottomClose, topFar);
            } else {
                bottomClose = this.m_58899_().m_7918_(-6, 0, -6);
                BlockPos topFar = this.m_58899_().m_7918_(6, 0, 6).m_5484_(facing, 6);
                area = new AABB(bottomClose, topFar);
            }
            List<ItemEntity> items = ElectromagnetBlockEntity.performMagnetAttraction(this.getLevelNonnull(), area, 0.75, sourcePos, Vec3.f_82478_, this.m_58899_().m_123344_(), () -> true);
            items.forEach(itemEntity -> {
                if (itemEntity.m_20238_(sourcePos) <= 1.0) {
                    itemEntity.getPersistentData().m_128405_("immersiveengineering:magnet_last_pulled", itemEntity.f_19797_);
                }
            });
        }
    }

    public static List<ItemEntity> performMagnetAttraction(Level world, AABB targetArea, double minimumDistance, Vec3 sourcePosition, Vec3 sourceMovement, String sourceName, Supplier<Boolean> hasConsumedEnergy) {
        List items = world.m_6443_(ItemEntity.class, targetArea, (Predicate)MAGNET_SOURCE_PREDICATE.getUnchecked((Object)sourceName));
        for (ItemEntity itemEntity : items) {
            Vec3 dist = sourcePosition.m_82546_(itemEntity.m_20182_());
            if (!(dist.m_82553_() > minimumDistance) || !hasConsumedEnergy.get().booleanValue()) continue;
            if (!itemEntity.getPersistentData().m_128441_("immersiveengineering:magnet_source")) {
                itemEntity.m_5496_((SoundEvent)IESounds.electromagnet.get(), (float)(0.125 + world.m_213780_().m_188500_() * 0.25), 1.0f);
                itemEntity.getPersistentData().m_128359_("immersiveengineering:magnet_source", sourceName);
            }
            Vec3 movementRequired = new Vec3(Math.min(dist.f_82479_, 1.0), Math.min(dist.f_82480_, 1.0), Math.min(dist.f_82481_, 1.0)).m_82546_(sourceMovement);
            itemEntity.m_20256_(movementRequired.m_82490_(0.2));
        }
        return items;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.redstoneControlInverted = nbt.m_128471_("redstoneInverted");
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128379_("redstoneInverted", this.redstoneControlInverted);
        EnergyHelper.serializeTo(this.energyStorage, nbt);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (side == null || side != this.getFacing())) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_INVERTED;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (player.m_6144_() && !this.getLevelNonnull().f_46443_) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            player.m_5661_((Component)Component.m_237115_((String)("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))), true);
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
        return InteractionResult.SUCCESS;
    }
}

