/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block;

import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class ProductiveSaplingBlock
extends SaplingBlock {
    private final TreeObject treeObject;

    public ProductiveSaplingBlock(AbstractTreeGrower grower, BlockBehaviour.Properties properties, TreeObject treeObject) {
        super(grower, properties);
        this.treeObject = treeObject;
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_204336_(this.treeObject.getSoil());
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean p_55994_) {
        return this.treeObject.canForceGrowth();
    }

    public TreeObject getTree() {
        return this.treeObject;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter blockGetter, List<Component> tooltips, TooltipFlag flag) {
        BlockItem blockItem;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof ProductiveSaplingBlock) {
            ProductiveSaplingBlock saplingBlock = (ProductiveSaplingBlock)item;
            tooltips.add((Component)Component.m_237115_((String)("block.productivetrees." + saplingBlock.treeObject.getId().m_135815_() + ".latin")).m_130940_(ChatFormatting.DARK_GREEN).m_130940_(ChatFormatting.ITALIC));
            super.m_5871_(stack, blockGetter, tooltips, flag);
            Object configurations = "";
            if (!saplingBlock.treeObject.getFeature().equals(TreeRegistrator.NULL_FEATURE)) {
                configurations = (String)configurations + "1x1 ";
            }
            if (!saplingBlock.treeObject.getMegaFeature().equals(TreeRegistrator.NULL_FEATURE)) {
                configurations = (String)configurations + "2x2 ";
            }
            if (!((String)configurations).isEmpty()) {
                tooltips.add((Component)Component.m_237110_((String)"productivetrees.sapling.configurations", (Object[])new Object[]{configurations}).m_130940_(ChatFormatting.GOLD));
            }
        } else {
            super.m_5871_(stack, blockGetter, tooltips, flag);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (random.m_188503_(7) == 0 && this.canGrowAtPos(level, pos)) {
            this.m_222000_(level, pos, state, random);
        }
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        ServerLevel serverLevel;
        return super.m_214167_(level, random, pos, state) && level instanceof ServerLevel && this.canGrowAtPos(serverLevel = (ServerLevel)level, pos);
    }

    private boolean canGrowAtPos(ServerLevel level, BlockPos pos) {
        int lightLevel = level.m_46803_(pos.m_7494_());
        if (lightLevel >= this.treeObject.getGrowthConditions().minLight() && lightLevel <= this.treeObject.getGrowthConditions().maxLight()) {
            if (!this.treeObject.getGrowthConditions().fluid().equals(Fluids.f_76191_) && !level.m_6425_(pos).m_192917_(this.treeObject.getGrowthConditions().fluid())) {
                return false;
            }
            Holder biome = level.m_204166_(pos);
            return this.treeObject.getGrowthConditions().biome() == null || this.treeObject.getGrowthConditions().biome().isEmpty() || this.treeObject.getGrowthConditions().biome().get().m_203333_(biome);
        }
        return true;
    }
}

