/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block.entity;

import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivetrees.inventory.PollenSifterContainer;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PollenSifterBlockEntity
extends CapabilityBlockEntity
implements MenuProvider {
    protected int tickCounter = 0;
    public int tickRate = 10;
    public int recipeTime = 600;
    public int progress = 0;
    public static int SLOT_IN = 0;
    public static int SLOT_OUT = 1;
    private final LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.BlockEntityItemStackHandler(2, (BlockEntity)this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (this.isInputSlotItem(slot, stack)) {
                return true;
            }
            return slot != SLOT_IN;
        }

        public boolean isInputSlot(int slot) {
            return slot == SLOT_IN;
        }

        public boolean isInputSlotItem(int slot, ItemStack stack) {
            if (slot == SLOT_IN && PollenSifterBlockEntity.this.canProcess(stack)) {
                ItemStack currentOutStack = this.getStackInSlot(slot);
                return currentOutStack.m_41619_() || currentOutStack.m_41613_() < currentOutStack.m_41741_() && ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)currentOutStack);
            }
            return false;
        }

        public boolean isInsertableSlot(int slot) {
            return slot == SLOT_IN;
        }

        public int[] getOutputSlots() {
            return new int[]{SLOT_OUT};
        }
    });

    private boolean canProcess(ItemStack stack) {
        return stack.m_204117_(ModTags.POLLINATABLE_ITEM);
    }

    public PollenSifterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TreeRegistrator.POLLEN_SIFTER_BLOCK_ENTITY.get(), pos, state);
    }

    public Component m_7755_() {
        return Component.m_237115_((String)((Block)TreeRegistrator.POLLEN_SIFTER.get()).m_7705_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PollenSifterBlockEntity blockEntity) {
        if (++blockEntity.tickCounter % blockEntity.tickRate == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockEntity.inventoryHandler.ifPresent(inv -> {
                Item patt3845$temp;
                ItemStack leaf = inv.getStackInSlot(SLOT_IN);
                ItemStack output = inv.getStackInSlot(SLOT_OUT);
                if (!leaf.m_41619_() && (patt3845$temp = leaf.m_41720_()) instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)patt3845$temp;
                    if (output.m_41619_() || output.m_150930_((Item)TreeRegistrator.POLLEN.get())) {
                        ItemStack pollenStack = TreeUtil.getPollen(blockItem.m_40614_());
                        if (output.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)pollenStack)) {
                            blockEntity.progress += blockEntity.tickRate;
                            if (blockEntity.progress >= blockEntity.recipeTime) {
                                if (level.f_46441_.m_188503_(100) <= 10) {
                                    inv.insertItem(SLOT_OUT, pollenStack, false);
                                }
                                leaf.m_41774_(1);
                                blockEntity.progress = 0;
                            }
                        }
                    }
                }
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new PollenSifterContainer(windowId, playerInventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        this.progress = tag.m_128451_("RecipeProgress");
    }

    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        tag.m_128405_("RecipeProgress", this.progress);
    }
}

