/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.part;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.IPartSerializer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.IGearComponent;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.part.PartData;

public interface IGearPart
extends IGearComponent<IPartData> {
    public ResourceLocation getId();

    public int getTier(PartData var1);

    default public int getTier() {
        return this.getTier(PartData.of(this));
    }

    public Tier getHarvestTier(IPartData var1);

    public PartType getType();

    default public GearType getGearType() {
        return GearType.ALL;
    }

    public IPartSerializer<?> getSerializer();

    default public String getPackName() {
        return "PACK UNKNOWN";
    }

    default public void retainData(@Nullable IGearPart oldPart) {
    }

    @Override
    default public MaterialList getMaterials(IPartData part) {
        return MaterialList.empty();
    }

    default public double getSalvageLossRate(PartData part, ItemStack gear, double normalLossRate) {
        return normalLossRate;
    }

    default public boolean isCraftingAllowed(IPartData part, GearType gearType) {
        if (gearType.isGear() && this.getType() == PartType.MAIN) {
            StatGearKey key = StatGearKey.of(gearType.getDurabilityStat(), gearType);
            return this.getStatUnclamped(part, this.getType(), key, ItemStack.f_41583_) > 0.0f;
        }
        return true;
    }

    @Override
    default public boolean isCraftingAllowed(IPartData part, PartType partType, GearType gearType, @Nullable Container inventory) {
        return this.isCraftingAllowed(part, gearType);
    }

    default public void onGearDamaged(PartData part, ItemStack gear, int amount) {
    }

    public int getColor(PartData var1, ItemStack var2, int var3, int var4);

    default public Component getDisplayName(@Nullable PartData part) {
        return this.getDisplayName(part, ItemStack.f_41583_);
    }

    public Component getDisplayName(@Nullable PartData var1, ItemStack var2);

    default public Component getMaterialName(@Nullable PartData part, ItemStack gear) {
        return this.getDisplayName(part, gear);
    }

    @Nullable
    default public Component getDisplayNamePrefix(@Nullable PartData part, ItemStack gear) {
        return null;
    }

    default public String getModelKey(PartData part) {
        return SilentGear.shortenId(this.getId());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(PartData var1, ItemStack var2, List<Component> var3, TooltipFlag var4);

    default public boolean isVisible() {
        return true;
    }

    default public PartData randomizeData(GearType gearType, int tier) {
        return PartData.of(this);
    }

    public boolean canAddToGear(ItemStack var1, PartData var2);

    default public boolean replacesExistingInPosition(PartData part) {
        return true;
    }

    default public void onAddToGear(ItemStack gear, PartData part) {
    }

    default public void onRemoveFromGear(ItemStack gear, PartData part) {
    }
}

