/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.ApiConst;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.TraitHelper;

@Mod.EventBusSubscriber
public class BlockMiningSpeedTrait
extends SimpleTrait {
    public static final ITraitSerializer<BlockMiningSpeedTrait> SERIALIZER = new SimpleTrait.Serializer<BlockMiningSpeedTrait>(ApiConst.BLOCK_MINING_SPEED_TRAIT_ID, BlockMiningSpeedTrait::new, (trait, json) -> {
        trait.speedMultiplier = GsonHelper.m_13820_((JsonObject)json, (String)"speed_multiplier", (float)1.0f);
        trait.blocks = BlockMiningSpeedTrait.deserialzeBlocks(json);
    }, (trait, buf) -> {
        trait.speedMultiplier = buf.readFloat();
        trait.blocks = BlockMiningSpeedTrait.readBlocksFromNetwork(buf);
    }, (trait, buf) -> {
        buf.writeFloat(trait.speedMultiplier);
        BlockMiningSpeedTrait.writeBlocksToNetwork(buf, trait.blocks);
    });
    private Collection<TagKey<Block>> blocks;
    private float speedMultiplier;

    public BlockMiningSpeedTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack tool = event.getEntity().m_21205_();
        Map<ITrait, Integer> traits = TraitHelper.getCachedTraits(tool);
        for (Map.Entry<ITrait, Integer> entry : traits.entrySet()) {
            ITrait trait = entry.getKey();
            if (!(trait instanceof BlockMiningSpeedTrait)) continue;
            int level = entry.getValue();
            float multiplier = ((BlockMiningSpeedTrait)trait).speedMultiplier;
            float newSpeed = event.getNewSpeed() * (float)level * (1.0f + multiplier);
            event.setNewSpeed(newSpeed);
            SilentGear.LOGGER.debug((Object)Float.valueOf(newSpeed));
        }
    }

    private static Collection<TagKey<Block>> deserialzeBlocks(JsonObject json) {
        JsonElement je = json.get("blocks");
        if (je.isJsonArray()) {
            HashSet ret = Sets.newHashSet();
            for (JsonElement e : je.getAsJsonArray()) {
                ret.add(BlockTags.create((ResourceLocation)new ResourceLocation(e.getAsString())));
            }
            return ret;
        }
        return Collections.singleton(BlockTags.create((ResourceLocation)new ResourceLocation(je.getAsString())));
    }

    private static Collection<TagKey<Block>> readBlocksFromNetwork(FriendlyByteBuf buf) {
        HashSet blocks = Sets.newHashSet();
        int count = buf.m_130242_();
        for (int i = 0; i < count; ++i) {
            blocks.add(BlockTags.create((ResourceLocation)buf.m_130281_()));
        }
        return blocks;
    }

    private static void writeBlocksToNetwork(FriendlyByteBuf buf, Collection<TagKey<Block>> blocks) {
        buf.m_130130_(blocks.size());
        for (TagKey<Block> tag : blocks) {
            buf.m_130085_(tag.f_203868_());
        }
    }
}

