/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.advpump.TileAdvPump;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public final class AdvPumpMessage
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final boolean placeFrame;
    private final boolean deleteFluid;

    AdvPumpMessage(BlockPos pos, ResourceKey<Level> dim, boolean placeFrame, boolean deleteFluid) {
        this.pos = pos;
        this.dim = dim;
        this.placeFrame = placeFrame;
        this.deleteFluid = deleteFluid;
    }

    AdvPumpMessage(TileAdvPump advPump) {
        this(advPump.m_58899_(), (ResourceKey<Level>)Objects.requireNonNull(advPump.m_58904_()).m_46472_(), advPump.placeFrame, advPump.deleteFluid);
    }

    public AdvPumpMessage(FriendlyByteBuf buf) {
        this(buf.m_130135_(), (ResourceKey<Level>)buf.m_236801_(Registries.f_256858_), buf.readBoolean(), buf.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos).m_236858_(this.dim);
        buf.writeBoolean(this.placeFrame).writeBoolean(this.deleteFluid);
    }

    public static void onReceive(AdvPumpMessage message, Supplier<NetworkEvent.Context> supplier) {
        Optional<Level> level = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> level.flatMap(l -> l.m_141902_(message.pos, Holder.ADV_PUMP_TYPE)).ifPresentOrElse(pump -> {
            pump.deleteFluid = message.deleteFluid;
            pump.placeFrame = message.placeFrame;
        }, () -> QuarryPlus.LOGGER.warn("{} can't find tile at {} in {}", (Object)message.getClass().getName(), (Object)message.pos, message.dim)));
    }
}

