/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yogpc.qp.machines.workbench.IngredientWithCount;
import com.yogpc.qp.utils.MapMulti;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class IngredientList
implements Predicate<ItemStack> {
    private final List<IngredientWithCount> ingredientList;

    public IngredientList(List<IngredientWithCount> ingredientList) {
        this.ingredientList = ingredientList;
    }

    public IngredientList(IngredientWithCount ingredient) {
        this(List.of(ingredient));
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.ingredientList.stream().anyMatch(t -> t.test(stack));
    }

    boolean shrink(ItemStack stack) {
        return this.ingredientList.stream().anyMatch(t -> t.shrink(stack));
    }

    boolean invalid() {
        return this.ingredientList.stream().allMatch(t -> t.ingredient().m_43947_());
    }

    public List<ItemStack> stackList() {
        return this.ingredientList.stream().flatMap(i -> i.stackList().stream()).toList();
    }

    public JsonElement toJson() {
        if (this.ingredientList.size() == 1) {
            return this.ingredientList.get(0).toJson();
        }
        return (JsonElement)this.ingredientList.stream().map(IngredientWithCount::toJson).collect(MapMulti.jsonArrayCollector());
    }

    public static IngredientList fromJson(JsonElement jsonElement) {
        if (jsonElement instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement;
            return new IngredientList(IngredientWithCount.getSeq((JsonElement)array));
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonElement;
            return new IngredientList(new IngredientWithCount(object));
        }
        throw new IllegalArgumentException("Invalid Json type: " + String.valueOf(jsonElement.getClass()) + " value=" + String.valueOf(jsonElement));
    }

    public void toPacket(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.ingredientList.size());
        for (IngredientWithCount ingredient : this.ingredientList) {
            ingredient.toPacket(buffer);
        }
    }

    public static IngredientList fromPacket(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        List<IngredientWithCount> list = Stream.generate(() -> IngredientWithCount.fromPacket(buffer)).limit(size).toList();
        return new IngredientList(list);
    }
}

