/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting;

import com.blakebr0.cucumber.event.RecipeManagerLoadingEvent;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.crafting.ingredient.JetpackTierIngredient;
import com.blakebr0.ironjetpacks.crafting.recipe.JetpackUpgradeRecipe;
import com.blakebr0.ironjetpacks.init.ModItems;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DynamicRecipeManager {
    private static final DynamicRecipeManager INSTANCE = new DynamicRecipeManager();

    @SubscribeEvent
    public void onRecipeManagerLoading(RecipeManagerLoadingEvent event) {
        JetpackRegistry.getInstance().loadJetpacks();
        for (Jetpack jetpack : JetpackRegistry.getInstance().getJetpacks()) {
            ShapedRecipe cell = DynamicRecipeManager.makeCellRecipe(jetpack);
            ShapedRecipe thruster = DynamicRecipeManager.makeThrusterRecipe(jetpack);
            ShapedRecipe capacitor = DynamicRecipeManager.makeCapacitorRecipe(jetpack);
            ShapedRecipe jetpackSelf = DynamicRecipeManager.makeJetpackRecipe(jetpack);
            JetpackUpgradeRecipe jetpackUpgrade = DynamicRecipeManager.makeJetpackUpgradeRecipe(jetpack);
            if (cell != null) {
                event.addRecipe((Recipe)cell);
            }
            if (thruster != null) {
                event.addRecipe((Recipe)thruster);
            }
            if (capacitor != null) {
                event.addRecipe((Recipe)capacitor);
            }
            if (jetpackSelf != null) {
                event.addRecipe((Recipe)jetpackSelf);
            }
            if (jetpackUpgrade == null) continue;
            event.addRecipe((Recipe)jetpackUpgrade);
        }
    }

    public static DynamicRecipeManager getInstance() {
        return INSTANCE;
    }

    private static ShapedRecipe makeCellRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_CELL_RECIPES.get()).booleanValue()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        Ingredient coil = Ingredient.m_43929_((ItemLike[])new ItemLike[]{JetpackRegistry.getInstance().getCoilForTier(jetpack.tier)});
        Ingredient redstone = Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE);
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.f_43901_, redstone, Ingredient.f_43901_, material, coil, material, Ingredient.f_43901_, redstone, Ingredient.f_43901_});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_cell");
        ItemStack output = JetpackUtils.getItemForComponent((Item)ModItems.CELL.get(), jetpack);
        return new ShapedRecipe(name, "ironjetpacks:cells", CraftingBookCategory.MISC, 3, 3, inputs, output);
    }

    private static ShapedRecipe makeThrusterRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_THRUSTER_RECIPES.get()).booleanValue()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        Ingredient coil = Ingredient.m_43929_((ItemLike[])new ItemLike[]{JetpackRegistry.getInstance().getCoilForTier(jetpack.tier)});
        StrictNBTIngredient cell = StrictNBTIngredient.of((ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.CELL.get(), jetpack));
        Ingredient furnace = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50094_});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{material, coil, material, coil, cell, coil, material, furnace, material});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_thruster");
        ItemStack output = JetpackUtils.getItemForComponent((Item)ModItems.THRUSTER.get(), jetpack);
        return new ShapedRecipe(name, "ironjetpacks:thrusters", CraftingBookCategory.MISC, 3, 3, inputs, output);
    }

    private static ShapedRecipe makeCapacitorRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_CAPACITOR_RECIPES.get()).booleanValue()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        StrictNBTIngredient cell = StrictNBTIngredient.of((ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.CELL.get(), jetpack));
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{material, cell, material, material, cell, material, material, cell, material});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_capacitor");
        ItemStack output = JetpackUtils.getItemForComponent((Item)ModItems.CAPACITOR.get(), jetpack);
        return new ShapedRecipe(name, "ironjetpacks:capacitors", CraftingBookCategory.MISC, 3, 3, inputs, output);
    }

    private static ShapedRecipe makeJetpackRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_JETPACK_RECIPES.get()).booleanValue()) {
            return null;
        }
        if (jetpack.tier != JetpackRegistry.getInstance().getLowestTier()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        StrictNBTIngredient capacitor = StrictNBTIngredient.of((ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.CAPACITOR.get(), jetpack));
        StrictNBTIngredient thruster = StrictNBTIngredient.of((ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.THRUSTER.get(), jetpack));
        Ingredient strap = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAP.get()});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{material, capacitor, material, material, strap, material, thruster, Ingredient.f_43901_, thruster});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_jetpack");
        ItemStack output = JetpackUtils.getItemForJetpack(jetpack);
        return new ShapedRecipe(name, "ironjetpacks:jetpacks", CraftingBookCategory.EQUIPMENT, 3, 3, inputs, output);
    }

    private static JetpackUpgradeRecipe makeJetpackUpgradeRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_JETPACK_RECIPES.get()).booleanValue()) {
            return null;
        }
        if (jetpack.tier == JetpackRegistry.getInstance().getLowestTier()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.f_43901_) {
            return null;
        }
        StrictNBTIngredient capacitor = StrictNBTIngredient.of((ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.CAPACITOR.get(), jetpack));
        StrictNBTIngredient thruster = StrictNBTIngredient.of((ItemStack)JetpackUtils.getItemForComponent((Item)ModItems.THRUSTER.get(), jetpack));
        JetpackTierIngredient jetpackTier = new JetpackTierIngredient(jetpack.tier - 1);
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{material, capacitor, material, material, jetpackTier, material, thruster, Ingredient.f_43901_, thruster});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_jetpack");
        ItemStack output = JetpackUtils.getItemForJetpack(jetpack);
        return new JetpackUpgradeRecipe(name, "ironjetpacks:jetpacks", 3, 3, (NonNullList<Ingredient>)inputs, output, false);
    }
}

