/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import sonar.fluxnetworks.api.FluxTranslate;

public enum AccessLevel {
    OWNER(FluxTranslate.OWNER, 0xFFAA00, ChatFormatting.GOLD),
    ADMIN(FluxTranslate.ADMIN, 0x66CC00, ChatFormatting.GREEN),
    USER(FluxTranslate.USER, 0x6699FF, ChatFormatting.BLUE),
    BLOCKED(FluxTranslate.BLOCKED, 0xA9A9A9, ChatFormatting.GRAY),
    SUPER_ADMIN(FluxTranslate.SUPER_ADMIN, 4915330, ChatFormatting.DARK_PURPLE);

    private static final AccessLevel[] VALUES;
    private final FluxTranslate localization;
    private final int color;
    private final ChatFormatting formatting;

    private AccessLevel(FluxTranslate localization, int color, ChatFormatting formatting) {
        this.localization = localization;
        this.color = color;
        this.formatting = formatting;
    }

    @Nonnull
    public static AccessLevel fromKey(byte key) {
        return VALUES[key];
    }

    public byte getKey() {
        return (byte)this.ordinal();
    }

    @Nonnull
    public String getFormattedName() {
        return this.formatting + this.localization.get();
    }

    public int getColor() {
        return this.color;
    }

    public boolean canUse() {
        return this != BLOCKED;
    }

    public boolean canEdit() {
        return this.canUse() && this != USER;
    }

    public boolean canDelete() {
        return this == OWNER || this == SUPER_ADMIN;
    }

    static {
        VALUES = AccessLevel.values();
    }
}

