/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.crafting.NBTWipeRecipe;

public class NBTWipeRecipeSerializer
implements RecipeSerializer<NBTWipeRecipe> {
    public static final NBTWipeRecipeSerializer INSTANCE = new NBTWipeRecipeSerializer();

    private NBTWipeRecipeSerializer() {
    }

    @Nonnull
    public NBTWipeRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        return new NBTWipeRecipe((ShapelessRecipe)RecipeSerializer.f_44077_.m_6729_(recipeId, json));
    }

    @Nullable
    public NBTWipeRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        try {
            ShapelessRecipe recipe = (ShapelessRecipe)RecipeSerializer.f_44077_.m_8005_(recipeId, buffer);
            if (recipe != null) {
                return new NBTWipeRecipe(recipe);
            }
        }
        catch (Exception e) {
            FluxNetworks.LOGGER.error("Error reading NBT Wipe Recipe from Packet", (Throwable)e);
        }
        return null;
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull NBTWipeRecipe recipe) {
        try {
            RecipeSerializer.f_44077_.m_6178_(buffer, (Recipe)recipe);
        }
        catch (Exception e) {
            FluxNetworks.LOGGER.error("Error writing NBT Wipe Recipe to packet.", (Throwable)e);
        }
    }
}

