/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.energy.IBlockEnergyConnector;
import sonar.fluxnetworks.common.connection.TransferHandler;
import sonar.fluxnetworks.common.device.SideTransfer;
import sonar.fluxnetworks.common.util.EnergyUtils;
import sonar.fluxnetworks.common.util.FluxUtils;

public abstract class FluxConnectorHandler
extends TransferHandler {
    protected final SideTransfer[] mTransfers = new SideTransfer[FluxUtils.DIRECTIONS.length];

    protected FluxConnectorHandler() {
        super(FluxConfig.defaultLimit);
    }

    @Override
    public void onCycleStart() {
        for (SideTransfer transfer : this.mTransfers) {
            if (transfer == null) continue;
            transfer.onCycleStart();
        }
    }

    @Override
    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        super.writeCustomTag(tag, type);
        tag.m_128356_("buffer", this.mBuffer);
    }

    public int updateSideTransfer(@Nonnull Direction side, @Nullable BlockEntity target, boolean fullState) {
        int connection;
        IBlockEnergyConnector connector;
        int index = side.m_122411_();
        SideTransfer transfer = this.mTransfers[index];
        if (target == null || (connector = EnergyUtils.getConnector(target, side.m_122424_())) == null) {
            if (transfer != null) {
                transfer.set(null, null);
            }
            connection = 0;
        } else {
            if (transfer == null) {
                this.mTransfers[index] = transfer = new SideTransfer(side);
            }
            transfer.set(target, connector);
            connection = 1 << index;
        }
        if (fullState) {
            int e = this.mTransfers.length;
            for (int i = 0; i < e; ++i) {
                if (i == index || (transfer = this.mTransfers[i]) == null || transfer.getTarget() == null) continue;
                connection |= 1 << i;
            }
        }
        return connection;
    }
}

